/*
 * Decompiled with CFR 0.152.
 */
package de.lwsystems.mailarchive.bennoarchive;

import de.lwsystems.mailarchive.Benno;
import de.lwsystems.mailarchive.BennoShutdownInterceptor;
import de.lwsystems.mailarchive.BennoSignalHandler;
import de.lwsystems.mailarchive.IBennoApplication;
import de.lwsystems.mailarchive.archive.ArchiveException;
import de.lwsystems.mailarchive.archive.IArchive;
import de.lwsystems.mailarchive.archive.container.IContainer;
import de.lwsystems.mailarchive.bennoarchive.ManagementClient;
import de.lwsystems.mailarchive.bennoarchive.removedocument.RemoveDocumentIndex;
import de.lwsystems.mailarchive.bennoarchive.softremove.SoftRemoveMailDocument;
import de.lwsystems.mailarchive.config.BennoConfig;
import de.lwsystems.mailarchive.config.DeleteMailCondition;
import de.lwsystems.mailarchive.mailservice.IMailService;
import de.lwsystems.mailarchive.mailservice.IMailServiceHost;
import de.lwsystems.mailarchive.remove.RemoveDocument;
import de.lwsystems.mailarchive.utils.BennoBuildTime;
import de.lwsystems.mailarchive.utils.BennoVersion;
import de.lwsystems.mailarchive.utils.CommandLineUtil;
import de.lwsystems.mailarchive.utils.PersistenceUtil;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.PosixParser;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.context.ApplicationContext;
import org.springframework.context.support.ClassPathXmlApplicationContext;

public final class BennoArchive
implements IMailServiceHost,
IBennoApplication {
    private static final Logger LOGGER = LogManager.getLogger(BennoArchive.class);
    private static final String DELETE_MODE = "delindex";
    private final ArrayList<IMailService> services = new ArrayList();
    private transient Benno benno;
    private transient String managementAddress = "127.0.0.1";
    private transient int managementPort = 0;
    private File configFile;
    private ServerSocket managementSocket = null;

    public static void main(String[] args) throws Exception {
        boolean success = false;
        try {
            Benno.configureLogging();
            BennoArchive archive = new BennoArchive();
            if (archive.getBenno(args, false)) {
                LOGGER.info("Starting bennoarchive: " + BennoVersion.archiveVersion() + " (" + BennoBuildTime.archiveBuildTime() + ") / bennocore: " + BennoVersion.coreVersion() + " (" + BennoBuildTime.coreBuildTime() + ")");
                archive.start();
            } else {
                Runtime.getRuntime().exit(1);
            }
        }
        catch (Throwable ex) {
            ex.printStackTrace();
            System.err.println(ex);
            LOGGER.fatal(ex.toString());
            Runtime.getRuntime().exit(2);
        }
    }

    private static Map<String, Object> createAdditionalBeansMap(DeleteMailCondition deleteMailCondition) {
        HashMap<String, Object> additionalBeans = new HashMap<String, Object>();
        additionalBeans.put("deleteMailCondition", deleteMailCondition);
        return additionalBeans;
    }

    private static ClassPathXmlApplicationContext registerApplicationContext(Map<String, Object> additionalBeans) {
        ClassPathXmlApplicationContext context = new ClassPathXmlApplicationContext("/spring/applicationContext.xml");
        return BennoArchive.registerBeansToApplicationContext(additionalBeans, context);
    }

    private static ClassPathXmlApplicationContext registerBeansToApplicationContext(Map<String, Object> additionalBeans, ClassPathXmlApplicationContext context) {
        additionalBeans.forEach((key, value) -> context.getBeanFactory().registerSingleton(key, value));
        return context;
    }

    private boolean getBenno(String[] args, boolean readOnly) throws Exception {
        boolean success = false;
        String cmdlineAddress = "0";
        BennoConfig config = null;
        PosixParser parser = new PosixParser();
        Options options = new Options();
        OptionBuilder.withArgName((String)"ADDRESS");
        OptionBuilder.withLongOpt((String)"bind-address");
        OptionBuilder.withDescription((String)"bind managemet to address ADDRESS");
        OptionBuilder.hasArg();
        OptionBuilder.withType(String.class);
        options.addOption(OptionBuilder.create((String)"b"));
        OptionBuilder.withArgName((String)"PORT");
        OptionBuilder.withLongOpt((String)"port");
        OptionBuilder.withDescription((String)"start management interface on port PORT");
        OptionBuilder.hasArg();
        OptionBuilder.withType(Number.class);
        options.addOption(OptionBuilder.create((String)"p"));
        OptionBuilder.withArgName((String)"CONFIGFILE");
        OptionBuilder.withLongOpt((String)"config");
        OptionBuilder.withDescription((String)"use configuraton from CONFIGFILE");
        OptionBuilder.hasArg();
        OptionBuilder.withType(String.class);
        options.addOption(OptionBuilder.create((String)"c"));
        OptionBuilder.withLongOpt((String)"help");
        OptionBuilder.withDescription((String)"print this description");
        options.addOption(OptionBuilder.create((String)"h"));
        OptionBuilder.withLongOpt((String)"print-config");
        OptionBuilder.withDescription((String)"print out actual configuration");
        options.addOption(OptionBuilder.create());
        OptionBuilder.withLongOpt((String)"default-config");
        OptionBuilder.withDescription((String)"print out default configuration");
        options.addOption(OptionBuilder.create());
        OptionBuilder.withLongOpt((String)"system-info");
        OptionBuilder.withDescription((String)"print out system information");
        options.addOption(OptionBuilder.create());
        OptionBuilder.withArgName((String)"SYSCONTAINER");
        OptionBuilder.withLongOpt((String)"status");
        OptionBuilder.withDescription((String)"");
        OptionBuilder.hasArg();
        OptionBuilder.withType(Number.class);
        options.addOption(OptionBuilder.create((String)"sc"));
        OptionBuilder.withArgName((String)"DELETE");
        OptionBuilder.withLongOpt((String)"delete");
        OptionBuilder.withDescription((String)"delete condition for mails in inbox");
        OptionBuilder.hasArg();
        OptionBuilder.withType(String.class);
        options.addOption(OptionBuilder.create((String)"d"));
        try {
            CommandLine cmdl = parser.parse(options, args, true);
            DeleteMailCondition deleteMailCondition = DeleteMailCondition.ALL;
            if (cmdl.hasOption("h")) {
                HelpFormatter formatter = new HelpFormatter();
                formatter.printHelp("java -jar bennoarchive.jar", options);
                Runtime.getRuntime().exit(0);
            } else {
                this.configFile = CommandLineUtil.findConfigFile((CommandLine)cmdl);
                if (this.configFile == null) {
                    System.err.println("No configfile found, exiting");
                    LOGGER.fatal("No configfile found, exiting");
                    Runtime.getRuntime().exit(99);
                }
                config = this.readConfig();
                if (cmdl.hasOption("b")) {
                    cmdlineAddress = (String)cmdl.getParsedOptionValue("b");
                }
                if (cmdl.hasOption("d")) {
                    deleteMailCondition = DeleteMailCondition.fromString((String)((String)cmdl.getParsedOptionValue("d")));
                }
                LOGGER.info("Delete mode in inbox is: " + deleteMailCondition.toString());
                if (cmdl.hasOption("p")) {
                    this.managementPort = ((Number)cmdl.getParsedOptionValue("p")).intValue();
                }
                if (cmdl.hasOption("print-config")) {
                    PersistenceUtil.createPersister().write((Object)config, (OutputStream)System.out);
                    Runtime.getRuntime().exit(0);
                }
                if (cmdl.hasOption("system-info")) {
                    System.out.println("bennoarchive: " + BennoVersion.archiveVersion() + " (" + BennoBuildTime.archiveBuildTime() + ")");
                    System.out.println("bennocore: " + BennoVersion.coreVersion() + " (" + BennoBuildTime.coreBuildTime() + ")");
                    this.getConfigString();
                    Runtime.getRuntime().exit(0);
                }
            }
            if (config != null) {
                this.benno = null;
                Map<String, Object> additionalBeans = BennoArchive.createAdditionalBeansMap(deleteMailCondition);
                ClassPathXmlApplicationContext context = BennoArchive.registerApplicationContext(additionalBeans);
                this.benno = new Benno(config, readOnly, (IMailServiceHost)this, (ApplicationContext)context);
                if (this.benno != null) {
                    success = true;
                    if (this.managementPort == 0) {
                        this.managementPort = config.managementPort;
                    }
                    this.managementAddress = cmdlineAddress == "0" ? config.managementAddress : cmdlineAddress;
                }
                this.addLostSoftDeleteMailsToIndex();
            }
        }
        catch (Exception exp) {
            HelpFormatter formatter = new HelpFormatter();
            StringWriter sWriter = new StringWriter();
            exp.printStackTrace();
            PrintWriter writer = new PrintWriter(sWriter);
            formatter.printHelp(writer, 80, "benno " + Benno.class.getPackage().getImplementationVersion(), "Commandline usage:", options, 1, 1, "Unexpected exception:" + exp.getMessage(), true);
            writer.flush();
            String message = sWriter.toString();
            System.err.println(message);
            LOGGER.fatal("FAILED TO LOAD BENNO");
            LOGGER.fatal(message);
            config = null;
        }
        return success;
    }

    private void addLostSoftDeleteMailsToIndex() {
        Iterable containers = this.benno.getArchives();
        for (IArchive archive : containers) {
            for (IContainer container : archive.getContainerGenerator().getContainers()) {
                try {
                    Path path = Paths.get(container.getIndexPathString() + "/delete.tmp", new String[0]);
                    try {
                        Stream<String> stream = Files.lines(path);
                        try {
                            stream.forEach(bennoId -> {
                                RemoveDocument deleteMail = RemoveDocument.getInstance((String)DELETE_MODE);
                                Optional<String> id = Optional.of(bennoId);
                                try {
                                    RemoveDocumentIndex removeDocumentIndex = new RemoveDocumentIndex(container, id);
                                    if (removeDocumentIndex.existsDocumentInIndex()) {
                                        SoftRemoveMailDocument myDoc = new SoftRemoveMailDocument(removeDocumentIndex.getMailFromRepo());
                                        if (deleteMail.isInstanceSet(DELETE_MODE)) {
                                            deleteMail.reserveDocumentForRemoving(removeDocumentIndex.getMailFromRepo());
                                        }
                                    }
                                }
                                catch (ArchiveException | IOException throwable) {
                                    // empty catch block
                                }
                            });
                        }
                        finally {
                            if (stream == null) continue;
                            stream.close();
                        }
                    }
                    catch (IOException iOException) {
                    }
                }
                catch (NullPointerException ex) {
                    LOGGER.debug("No index was found for container " + container.getIdentifier() + ". Therefore, no soft delete is offered.");
                }
            }
        }
    }

    private BennoConfig readConfig() throws Exception {
        return PersistenceUtil.readBennoConfig((File)this.configFile);
    }

    public IMailService registerService(IMailService service) {
        boolean isNew = true;
        for (IMailService existingService : this.services) {
            if (!existingService.equals(service)) continue;
            service = existingService;
            isNew = false;
        }
        if (isNew) {
            this.services.add(service);
        }
        return service;
    }

    public void start() {
        LOGGER.info("Starting management server on " + this.managementAddress + ":" + this.managementPort);
        try {
            Runtime.getRuntime().addShutdownHook((Thread)new BennoShutdownInterceptor((IBennoApplication)this));
            new BennoSignalHandler("TERM", (IBennoApplication)this);
            new BennoSignalHandler("HUP", (IBennoApplication)this);
            new BennoSignalHandler("INT", (IBennoApplication)this);
            new BennoSignalHandler("ABRT", (IBennoApplication)this);
            this.managementSocket = new ServerSocket(this.managementPort, 0, InetAddress.getByName(this.managementAddress));
        }
        catch (IOException ex) {
            LOGGER.error("Could not open management interface on port " + this.managementAddress + ":" + this.managementPort, (Throwable)ex);
            System.err.println("Could not open management interface on port " + this.managementAddress + ":" + this.managementPort);
            System.err.println(ex);
            System.exit(255);
        }
        if (this.managementSocket != null) {
            block6: {
                this.startServices();
                try {
                    while (this.managementSocket.isBound()) {
                        new Thread(new ManagementClient(this, this.managementSocket.accept())).run();
                    }
                }
                catch (Exception ex) {
                    LOGGER.info("Managementsocket closed");
                    if (!LOGGER.isDebugEnabled()) break block6;
                    LOGGER.debug("Socket exception ", (Throwable)ex);
                }
            }
            this.shutDown();
        }
    }

    public void startServices() {
        for (IMailService service : this.services) {
            service.start();
        }
    }

    public void stopServices() {
        for (IMailService service : this.services) {
            service.stop();
        }
    }

    public void listServices(PrintWriter out) {
        for (IMailService service : this.services) {
            out.print(service.toString());
            out.print(": ");
            out.println(service.getState());
        }
    }

    void listArchives(PrintWriter out) {
        this.benno.listArchives(out);
    }

    void optimizeIndex(String name, PrintWriter out) {
        this.benno.optimizeIndex(name, out);
    }

    public String getConfigString() {
        Object output = "";
        for (IMailService service : this.services) {
            output = (String)output + service.toString();
        }
        return output;
    }

    public void shutDown() {
        try {
            if (this.managementSocket != null) {
                this.managementSocket.close();
            }
        }
        catch (IOException ex) {
            LOGGER.error("Error closing management socket", (Throwable)ex);
        }
        finally {
            this.stopServices();
        }
    }

    public String getIdentifier() {
        return "Bennoarchive " + this.benno.getIdentifier();
    }

    public void reload() {
        try {
            BennoConfig newConfig = this.readConfig();
            this.benno.configure(newConfig);
        }
        catch (Exception e) {
            LOGGER.error((Object)e);
        }
    }

    public Benno getBenno() {
        return this.benno;
    }

    public void setBenno(Benno benno) {
        this.benno = benno;
    }
}

