/*
 * Decompiled with CFR 0.152.
 */
package de.lwsystems.mailarchive.bennoarchive.removedocument;

import de.lwsystems.mailarchive.archive.ArchiveException;
import de.lwsystems.mailarchive.archive.box.IBox;
import de.lwsystems.mailarchive.archive.box.MailDocumentId;
import de.lwsystems.mailarchive.archive.container.IContainer;
import de.lwsystems.mailarchive.maildocument.MailDocument;
import de.lwsystems.mailarchive.maildocument.RemovedMailDocument;
import java.io.IOException;
import java.util.Optional;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.store.Directory;

public class RemoveDocumentIndex {
    private IContainer container;
    private Optional<String> bennoMailId = Optional.empty();
    private IndexReader ireader;
    private IndexSearcher isearcher;
    private Query query;

    public RemoveDocumentIndex(IContainer container, Optional<String> bennoMailId) throws IOException {
        this.bennoMailId = bennoMailId;
        this.container = container;
        this.createIndexReader();
        this.createIndexSearcher();
        this.buildQuery();
    }

    public String getBennoMailId() {
        return this.bennoMailId.get().toString();
    }

    private void createIndexReader() throws IOException {
        this.ireader = IndexReader.open((Directory)this.container.getIndexPath());
    }

    private void createIndexSearcher() {
        this.isearcher = new IndexSearcher(this.ireader);
    }

    private void buildQuery() {
        this.query = new TermQuery(new Term("id", this.bennoMailId.get()));
    }

    public boolean existsDocumentInIndex() throws IOException {
        int hitsPerPage = 1;
        TopDocs docs = this.isearcher.search(this.query, hitsPerPage);
        return docs.scoreDocs.length > 0;
    }

    public RemovedMailDocument getMailFromRepo() throws ArchiveException {
        MailDocumentId documentId = new MailDocumentId(this.bennoMailId.get(), "");
        IBox box = this.container.getBox(documentId.getInternalBoxIndentifier());
        MailDocument myDoc = box.getDocument(documentId);
        RemovedMailDocument removedMailDocument = new RemovedMailDocument(myDoc, documentId);
        return removedMailDocument;
    }
}

