/*
 * Decompiled with CFR 0.152.
 */
package de.lwsystems.mailarchive.archive.box;

import de.lwsystems.mailarchive.archive.box.BoxState;
import de.lwsystems.mailarchive.archive.box.IBox;
import de.lwsystems.mailarchive.utils.BennoXmlDateTransform;
import java.util.Date;
import java.util.HashMap;
import org.simpleframework.xml.Attribute;
import org.simpleframework.xml.ElementMap;
import org.simpleframework.xml.Root;
import org.simpleframework.xml.core.Persister;
import org.simpleframework.xml.filter.Filter;
import org.simpleframework.xml.filter.PlatformFilter;
import org.simpleframework.xml.strategy.Strategy;
import org.simpleframework.xml.strategy.TreeStrategy;
import org.simpleframework.xml.transform.Matcher;
import org.simpleframework.xml.transform.Transform;

@Root(name="boxstate")
public class BoxGeneratorState {
    @Attribute
    private Integer configVersion = 2;
    private IBox actualBox = null;
    @ElementMap(entry="box", key="identifier", attribute=true, inline=true, required=false)
    private HashMap<String, BoxState> boxes = new HashMap();
    private boolean readOnly = true;

    public static Persister getPersister() {
        return new Persister((Strategy)new TreeStrategy("type", "count"), (Filter)new PlatformFilter(new HashMap()), new Matcher(){

            public Transform match(Class type) throws Exception {
                if (type == Date.class) {
                    return new BennoXmlDateTransform();
                }
                return null;
            }
        });
    }

    public HashMap<String, BoxState> getBoxes() {
        return this.boxes;
    }

    public IBox getActualBox() {
        return this.actualBox;
    }

    public void setActualBox(IBox actualBox) {
        if (this.actualBox != null) {
            this.boxes.get((Object)this.getActualBox().getIdentifier()).state = IBox.BOXSTATE.CLOSED;
        }
        this.actualBox = actualBox;
        this.boxes.put(actualBox.getIdentifier(), new BoxState(actualBox.getBoxConfig()));
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public void setReadOnly(boolean readOnly) {
        this.readOnly = readOnly;
    }

    public Integer getConfigVersion() {
        return this.configVersion;
    }

    public void setConfigVersion(Integer configVersion) {
        this.configVersion = configVersion;
    }
}

