/*
 * Decompiled with CFR 0.152.
 */
package de.lwsystems.mailarchive.archive.box;

import de.lwsystems.mailarchive.utils.ConversionUtil;

public class MailDocumentId {
    private final String internalBoxIndentifier;
    private final String hashHex;
    private final String scid;
    private final int sameHashDuplicateNumber;

    public MailDocumentId(String internalBoxIndentifier, String hashHex, int sameHashDuplicateNumber, String scid) {
        this.internalBoxIndentifier = internalBoxIndentifier;
        this.hashHex = hashHex;
        this.sameHashDuplicateNumber = sameHashDuplicateNumber;
        this.scid = scid;
    }

    public MailDocumentId(String completeId, String scid) {
        String boxInternalIdentifier = this.getBoxIdentifier(completeId);
        String fullId = this.getFullId(completeId);
        this.internalBoxIndentifier = boxInternalIdentifier;
        this.hashHex = fullId.substring(0, fullId.length() - 2);
        this.sameHashDuplicateNumber = ConversionUtil.fromHexToInt(fullId.substring(fullId.length() - 2));
        this.scid = scid;
    }

    public MailDocumentId(String completeId) {
        String boxInternalIdentifier = this.getBoxIdentifier(completeId);
        String fullId = this.getFullId(completeId);
        this.internalBoxIndentifier = boxInternalIdentifier;
        this.hashHex = fullId.substring(0, fullId.length() - 2);
        this.sameHashDuplicateNumber = ConversionUtil.fromHexToInt(fullId.substring(fullId.length() - 2));
        this.scid = "";
    }

    private String getFullId(String completeId) {
        return completeId.substring(completeId.indexOf(":") + 1);
    }

    private String getBoxIdentifier(String completeId) {
        return completeId.substring(0, completeId.indexOf(":"));
    }

    public String toString() {
        return (String)(this.internalBoxIndentifier != null && this.internalBoxIndentifier.length() > 0 ? this.internalBoxIndentifier + ":" : "") + this.hashHex + this.getDuplicateIdHex();
    }

    public String getDuplicateIdHex() {
        return ConversionUtil.fromIntToHex(this.sameHashDuplicateNumber);
    }

    public String getHashHex() {
        return this.hashHex;
    }

    public String getInternalBoxIndentifier() {
        return this.internalBoxIndentifier;
    }

    public String getScid() {
        return this.scid;
    }
}

