/*
 * Decompiled with CFR 0.152.
 */
package de.lwsystems.mailarchive.archive.journal;

import de.lwsystems.mailarchive.archive.journal.JournalReader;
import de.lwsystems.mailarchive.utils.CompressionUtil;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NotDirectoryException;
import java.nio.file.Path;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class FSJournalReader
extends JournalReader {
    private final Comparator<? super Path> lastModifiedComparator = (p1, p2) -> Long.compare(p1.toFile().lastModified(), p2.toFile().lastModified());

    @Override
    public BufferedReader getJournalFile(String container, String boxYear) {
        return null;
    }

    @Override
    public BufferedReader getOldestJournalFile(Path repoPath) throws IOException {
        if (Files.exists(repoPath, new LinkOption[0])) {
            try (Stream<Path> journalFiles = this.searchJournalFileInPath(repoPath);){
                Optional<List<Path>> oldestJournalFile = this.getJournalFilesInStream(journalFiles, 1);
                if (!oldestJournalFile.isPresent()) {
                    throw new FileNotFoundException();
                }
                Path journalFile = oldestJournalFile.get().get(0);
                BufferedReader bufferedReader = this.createBufferedReaderFromPath(journalFile);
                return bufferedReader;
            }
        }
        throw new NotDirectoryException(String.valueOf(repoPath) + " is not a directory");
    }

    @Override
    public BufferedReader createBufferedReaderFromPath(Path journalFile) throws IOException {
        return new BufferedReader(new InputStreamReader(this.generateInputStreamFromJournalFile(journalFile.toFile())));
    }

    private Optional<List<Path>> getJournalFilesInStream(Stream<Path> journalFiles, int limit) {
        List oldestJournalFiles = journalFiles.sorted(this.lastModifiedComparator).filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).limit(limit).collect(Collectors.toList());
        if (oldestJournalFiles.isEmpty()) {
            return Optional.empty();
        }
        return Optional.ofNullable(oldestJournalFiles);
    }

    @Override
    public List<Path> getAllJournalFiles(Path repoPath) throws IOException {
        if (Files.exists(repoPath, new LinkOption[0])) {
            try (Stream<Path> journalFiles = this.searchJournalFileInPath(repoPath);){
                List<Path> journalPathList;
                Optional<List<Path>> oldestJournalFile = this.getJournalFilesInStream(journalFiles, Integer.MAX_VALUE);
                if (!oldestJournalFile.isPresent()) {
                    throw new FileNotFoundException();
                }
                List<Path> list = journalPathList = oldestJournalFile.get();
                return list;
            }
        }
        throw new NotDirectoryException(String.valueOf(repoPath) + " is not a directory");
    }

    private InputStream generateInputStreamFromJournalFile(File journalFile) throws IOException {
        return CompressionUtil.getInStream(journalFile);
    }

    private Stream<Path> searchJournalFileInPath(Path repoPath) throws IOException {
        return Files.find(repoPath, Integer.MAX_VALUE, (path, basicFileAttributes) -> {
            File file = path.toFile();
            return file.getName().contains("journal") && file.isFile();
        }, new FileVisitOption[0]);
    }
}

