/*
 * Decompiled with CFR 0.152.
 */
package de.lwsystems.mailarchive.authentication.protocol;

import de.lwsystems.mailarchive.authentication.protocol.BennoAuthResult;
import de.lwsystems.mailarchive.authentication.protocol.BennoAuthResultBuilder;
import de.lwsystems.mailarchive.authentication.protocol.BennoAuthenticator;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public class BennoAuth {
    private final List<BennoAuthenticator> authenticators;
    private final Map<String, String> errorMessages;

    public static Map<String, String> parseMsgFile(InputStream inputStream) throws FileNotFoundException {
        BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream));
        HashMap<String, String> result = new HashMap<String, String>();
        reader.lines().filter(line -> !Pattern.matches("/^#/", line)).filter(line -> !Pattern.matches("/^\\s*$/", line)).forEach(line -> {
            String[] parts = line.split("\\s*=\\s*");
            result.put(parts[0], parts[1].replaceAll("[ \\t\\n\\r\\x0B]+$", ""));
        });
        return result;
    }

    public BennoAuth(String authenticatorDirectory, Map<String, String> errorMessages) throws IOException {
        this.authenticators = Files.list(Paths.get(authenticatorDirectory, new String[0])).map(path -> new BennoAuthenticator((Path)path, errorMessages)).collect(Collectors.toList());
        this.errorMessages = errorMessages;
    }

    public BennoAuthResult login(String username, String password) {
        BennoAuthResultBuilder builder = new BennoAuthResultBuilder();
        this.authenticators.forEach(auth -> auth.gatherAuthInfo(username, password, builder));
        return builder.createBennoAuthResult();
    }
}

