/*
 * Decompiled with CFR 0.152.
 */
package de.lwsystems.mailarchive.authentication.protocol;

import de.lwsystems.mailarchive.authentication.protocol.BennoAuthError;
import de.lwsystems.mailarchive.authentication.protocol.BennoAuthResultBuilder;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.nio.file.Path;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class BennoAuthenticator {
    private static final Logger LOGGER = LogManager.getLogger(BennoAuthenticator.class);
    public static final Pattern LINE_PATTERN = Pattern.compile("(\\w+)\\s+(.+)");
    private static final long BENNO_AUTH_TIMEOUT = 3L;
    private final Path path;
    private final Map<String, String> errorMessages;
    private Process process;
    private BufferedReader reader;

    BennoAuthenticator(Path path, Map<String, String> errorMessages) {
        this.path = path;
        this.errorMessages = errorMessages;
        this.restartProcess();
    }

    private void restartProcess() {
        ProcessBuilder processBuilder = new ProcessBuilder(new String[0]);
        processBuilder.command(this.path.toString());
        try {
            this.process = processBuilder.start();
            this.reader = new BufferedReader(new InputStreamReader(this.process.getInputStream()));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void gatherAuthInfo(String username, String password, BennoAuthResultBuilder builder) {
        try {
            OutputStream out = this.process.getOutputStream();
            out.write((username + "\n" + password + "\n").getBytes());
            out.flush();
            this.parseAuth(this.reader, builder);
            boolean didFinish = this.process.waitFor(3L, TimeUnit.SECONDS);
            if (didFinish) {
                this.reader.close();
                out.close();
                if (this.process.exitValue() != 0) {
                    LOGGER.error("Process " + this.path.toString() + " finished with return value != 0");
                }
            } else {
                LOGGER.error("Process " + this.path.toString() + " did not finish, destroying...");
                this.process.destroyForcibly();
            }
            this.restartProcess();
        }
        catch (IOException | InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    private void parseAuth(BufferedReader reader, BennoAuthResultBuilder builder) throws IOException {
        reader.lines().forEach(line -> {
            Matcher matcher = LINE_PATTERN.matcher((CharSequence)line);
            if (!matcher.matches()) {
                return;
            }
            String field = matcher.group(1);
            String value = matcher.group(2);
            switch (field) {
                case "ARCHIVE": {
                    builder.withArchive(value);
                    break;
                }
                case "ROLE": {
                    builder.withRole(value);
                    break;
                }
                case "DISPLAYNAME": {
                    builder.withDisplayName(value);
                    break;
                }
                case "MAIL": {
                    builder.withEmail(value);
                    break;
                }
                case "USERID": {
                    builder.withUserId(value);
                    break;
                }
                case "WARN": {
                    builder.withWarning(value);
                    break;
                }
                case "AUTH": {
                    builder.withValid(value.equals("OK"));
                    if (!value.equals("BREAK")) break;
                    builder.withBroken(true);
                    break;
                }
                case "RESTUSER": {
                    builder.withRestUser(value);
                    break;
                }
                case "RESTURL": {
                    builder.withRestUrl(value);
                    break;
                }
                case "RESTPASS": {
                    builder.withRestPassword(value);
                    break;
                }
                case "ERROR": {
                    builder.withError(new BennoAuthError(value, this.errorMessages.get(value)));
                }
            }
        });
        reader.close();
    }
}

