/*
 * Decompiled with CFR 0.152.
 */
package de.lwsystems.mailarchive.condition;

import de.lwsystems.mailarchive.condition.AbstractCondition;
import de.lwsystems.mailarchive.condition.AllCondition;
import de.lwsystems.mailarchive.condition.AndCondition;
import de.lwsystems.mailarchive.condition.ConditionConfigType;
import de.lwsystems.mailarchive.condition.MailAddressCondition;
import de.lwsystems.mailarchive.condition.MailDomainCondition;
import de.lwsystems.mailarchive.condition.NoneCondition;
import de.lwsystems.mailarchive.condition.NotCondition;
import de.lwsystems.mailarchive.condition.OrCondition;
import de.lwsystems.mailarchive.config.IConditionConfig;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Map;

public class ConditionFactory {
    private static Class<?>[] conditionClasses = new Class[]{OrCondition.class, AndCondition.class, AllCondition.class, MailAddressCondition.class, MailDomainCondition.class, NotCondition.class, NoneCondition.class};
    private static Map<IConditionConfig.ConditionType, Class<?>> conditionClassMap = new HashMap();

    public static AbstractCondition createCondition(IConditionConfig config) {
        try {
            Class<?> conditionClass = conditionClassMap.get((Object)config.getType());
            Constructor<?> constructor = conditionClass.getConstructor(config.getClass());
            return (AbstractCondition)constructor.newInstance(config);
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    static {
        for (Class<?> conditionClass : conditionClasses) {
            ConditionConfigType annotation = conditionClass.getAnnotation(ConditionConfigType.class);
            conditionClassMap.put(annotation.value(), conditionClass);
        }
    }
}

