/*
 * Decompiled with CFR 0.152.
 */
package de.lwsystems.mailarchive.index;

import de.lwsystems.mailarchive.Benno;
import de.lwsystems.mailarchive.config.OcrConfig;
import de.lwsystems.mailarchive.index.MailContentHandler;
import java.io.IOException;
import java.io.InputStream;
import org.apache.james.mime4j.MimeException;
import org.apache.james.mime4j.parser.ContentHandler;
import org.apache.james.mime4j.parser.MimeStreamParser;
import org.apache.james.mime4j.stream.MimeConfig;
import org.apache.lucene.document.Document;
import org.apache.tika.exception.TikaException;
import org.apache.tika.io.TaggedInputStream;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.parser.ParseContext;
import org.apache.tika.parser.mail.RFC822Parser;
import org.apache.tika.parser.ocr.TesseractOCRConfig;
import org.apache.tika.parser.pdf.PDFParserConfig;
import org.apache.tika.sax.XHTMLContentHandler;
import org.xml.sax.SAXException;

public class GracefulRFC882Parser
extends RFC822Parser {
    private static final long serialVersionUID = 8701157565517381006L;
    private final Benno benno;
    private Document document;

    public GracefulRFC882Parser(Benno benno, Document document) {
        this.document = document;
        this.benno = benno;
    }

    public void parse(InputStream stream, org.xml.sax.ContentHandler handler, Metadata metadata, ParseContext context) throws IOException, SAXException, TikaException {
        OcrConfig ocrConfig;
        MimeConfig config = new MimeConfig.Builder().setMaxLineLen(1000000).setMaxHeaderCount(30000).setMaxHeaderLen(1000000).build();
        config = (MimeConfig)context.get(MimeConfig.class, (Object)config);
        MimeStreamParser parser = new MimeStreamParser(config);
        XHTMLContentHandler xhtml = new XHTMLContentHandler(handler, metadata);
        if (this.benno != null && (ocrConfig = this.benno.getConfig().getOcrConfig()) != null) {
            TesseractOCRConfig tesseractOCRConfig = new TesseractOCRConfig();
            tesseractOCRConfig.setLanguage(ocrConfig.language);
            tesseractOCRConfig.setTessdataPath(ocrConfig.tesseractPath);
            tesseractOCRConfig.setMaxFileSizeToOcr((long)Integer.parseInt(ocrConfig.maxFileSizeToOcr));
            tesseractOCRConfig.setMinFileSizeToOcr((long)Integer.parseInt(ocrConfig.maxFileSizeToOcr));
            context.set(TesseractOCRConfig.class, (Object)tesseractOCRConfig);
            PDFParserConfig pdfConfig = new PDFParserConfig();
            pdfConfig.setExtractInlineImages(true);
            context.set(PDFParserConfig.class, (Object)pdfConfig);
        }
        MailContentHandler mch = new MailContentHandler(xhtml, metadata, context, config.isStrictParsing(), this.document);
        parser.setContentHandler((ContentHandler)mch);
        parser.setContentDecoding(true);
        TaggedInputStream tagged = TaggedInputStream.get((InputStream)stream);
        try {
            parser.parse((InputStream)tagged);
        }
        catch (IOException e) {
            tagged.throwIfCauseOf((Exception)e);
            throw new TikaException("Failed to parse an email message", (Throwable)e);
        }
        catch (MimeException e) {
            Throwable cause = e.getCause();
            if (cause instanceof TikaException) {
                throw (TikaException)cause;
            }
            if (cause instanceof SAXException) {
                throw (SAXException)cause;
            }
            throw new TikaException("Failed to parse an email message", (Throwable)e);
        }
    }
}

