/*
 * Decompiled with CFR 0.152.
 */
package de.lwsystems.mailarchive.index;

import de.lwsystems.mailarchive.utils.TikaUtils;
import java.io.IOException;
import java.io.InputStream;
import org.apache.james.mime4j.MimeException;
import org.apache.james.mime4j.codec.DecodeMonitor;
import org.apache.james.mime4j.codec.DecoderUtil;
import org.apache.james.mime4j.dom.address.Address;
import org.apache.james.mime4j.dom.address.AddressList;
import org.apache.james.mime4j.dom.address.Mailbox;
import org.apache.james.mime4j.dom.address.MailboxList;
import org.apache.james.mime4j.dom.field.AddressListField;
import org.apache.james.mime4j.dom.field.DateTimeField;
import org.apache.james.mime4j.dom.field.MailboxListField;
import org.apache.james.mime4j.dom.field.ParsedField;
import org.apache.james.mime4j.dom.field.UnstructuredField;
import org.apache.james.mime4j.field.LenientFieldParser;
import org.apache.james.mime4j.parser.ContentHandler;
import org.apache.james.mime4j.stream.BodyDescriptor;
import org.apache.james.mime4j.stream.Field;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.Fieldable;
import org.apache.tika.exception.TikaException;
import org.apache.tika.extractor.EmbeddedDocumentExtractor;
import org.apache.tika.extractor.ParsingEmbeddedDocumentExtractor;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.metadata.TikaCoreProperties;
import org.apache.tika.parser.ParseContext;
import org.apache.tika.parser.Parser;
import org.apache.tika.sax.BodyContentHandler;
import org.apache.tika.sax.EmbeddedContentHandler;
import org.apache.tika.sax.XHTMLContentHandler;
import org.xml.sax.SAXException;

class MailContentHandler
implements ContentHandler {
    private static final Logger LOGGER = LogManager.getLogger(MailContentHandler.class);
    private boolean strictParsing = false;
    private XHTMLContentHandler handler;
    private ParseContext context;
    private Metadata metadata;
    private EmbeddedDocumentExtractor extractor;
    private boolean inPart = false;
    private Document document;

    MailContentHandler(XHTMLContentHandler xhtml, Metadata metadata, ParseContext context, boolean strictParsing, Document document) {
        this.handler = xhtml;
        this.context = context;
        this.metadata = metadata;
        this.strictParsing = strictParsing;
        this.document = document;
        this.extractor = (EmbeddedDocumentExtractor)context.get(EmbeddedDocumentExtractor.class);
        if (this.extractor == null) {
            Parser parser = TikaUtils.getTikaParser(context);
            ParseContext ctx = new ParseContext();
            ctx.set(Parser.class, (Object)parser);
            this.extractor = new ParsingEmbeddedDocumentExtractor(ctx);
        }
    }

    public void body(BodyDescriptor body, InputStream is) throws MimeException, IOException {
        block5: {
            Parser parser = TikaUtils.getTikaParser(this.context);
            Metadata submd = new Metadata();
            submd.set("Content-Type", body.getMimeType());
            submd.set("Content-Encoding", body.getCharset());
            try {
                if (this.extractor.shouldParseEmbedded(submd)) {
                    this.extractor.parseEmbedded(is, (org.xml.sax.ContentHandler)this.handler, submd, false);
                }
                BodyContentHandler bch = new BodyContentHandler((org.xml.sax.ContentHandler)this.handler);
                parser.parse(is, (org.xml.sax.ContentHandler)new EmbeddedContentHandler((org.xml.sax.ContentHandler)bch), submd, this.context);
            }
            catch (SAXException e) {
                throw new MimeException((Throwable)e);
            }
            catch (IOException | NullPointerException | TikaException e) {
                if (this.document != null) {
                    this.document.add((Fieldable)new org.apache.lucene.document.Field("HasParseErrors", "yes", Field.Store.YES, Field.Index.NOT_ANALYZED));
                }
                if (!LOGGER.isDebugEnabled()) break block5;
                LOGGER.debug("Ignoring TikaException in mime part body " + body.toString() + ": Tika parser error: " + e.toString());
            }
        }
    }

    public void endBodyPart() throws MimeException {
        try {
            this.handler.endElement("p");
            this.handler.endElement("div");
        }
        catch (SAXException e) {
            throw new MimeException((Throwable)e);
        }
    }

    public void endHeader() throws MimeException {
    }

    public void startMessage() throws MimeException {
        try {
            this.handler.startDocument();
        }
        catch (SAXException e) {
            throw new MimeException((Throwable)e);
        }
    }

    public void endMessage() throws MimeException {
        try {
            this.handler.endDocument();
        }
        catch (SAXException e) {
            throw new MimeException((Throwable)e);
        }
    }

    public void endMultipart() throws MimeException {
        this.inPart = false;
    }

    public void epilogue(InputStream is) throws MimeException, IOException {
    }

    public void field(Field field) throws MimeException {
        block19: {
            if (this.inPart) {
                return;
            }
            try {
                String fieldname = field.getName();
                ParsedField parsedField = LenientFieldParser.getParser().parse(field, DecodeMonitor.SILENT);
                if (fieldname.equalsIgnoreCase("From")) {
                    MailboxListField fromField = (MailboxListField)parsedField;
                    MailboxList mailboxList = fromField.getMailboxList();
                    if (fromField.isValidField() && mailboxList != null) {
                        for (Address address : mailboxList) {
                            String from = this.getDisplayString(address);
                            this.metadata.add("Message-From", from);
                            this.metadata.add(TikaCoreProperties.CREATOR, from);
                        }
                    } else {
                        String from = this.stripOutFieldPrefix(field, "From:");
                        if (from.startsWith("<")) {
                            from = from.substring(1);
                        }
                        if (from.endsWith(">")) {
                            from = from.substring(0, from.length() - 1);
                        }
                        this.metadata.add("Message-From", from);
                        this.metadata.add(TikaCoreProperties.CREATOR, from);
                    }
                } else if (fieldname.equalsIgnoreCase("Subject")) {
                    this.metadata.add(TikaCoreProperties.TRANSITION_SUBJECT_TO_DC_TITLE, ((UnstructuredField)parsedField).getValue());
                } else if (fieldname.equalsIgnoreCase("To")) {
                    this.processAddressList(parsedField, "To:", "Message-To");
                } else if (fieldname.equalsIgnoreCase("CC")) {
                    this.processAddressList(parsedField, "Cc:", "Message-Cc");
                } else if (fieldname.equalsIgnoreCase("BCC")) {
                    this.processAddressList(parsedField, "Bcc:", "Message-Bcc");
                } else if (fieldname.equalsIgnoreCase("Date")) {
                    DateTimeField dateField = (DateTimeField)parsedField;
                    this.metadata.set(TikaCoreProperties.CREATED, dateField.getDate());
                }
            }
            catch (RuntimeException me) {
                if (!this.strictParsing) break block19;
                throw me;
            }
        }
    }

    private void processAddressList(ParsedField field, String addressListType, String metadataField) throws MimeException {
        AddressListField toField = (AddressListField)field;
        if (toField.isValidField()) {
            AddressList addressList = toField.getAddressList();
            for (Address address : addressList) {
                this.metadata.add(metadataField, this.getDisplayString(address));
            }
        } else {
            String to = this.stripOutFieldPrefix((Field)field, addressListType);
            for (String eachTo : to.split(",")) {
                this.metadata.add(metadataField, eachTo.trim());
            }
        }
    }

    private String getDisplayString(Address address) {
        if (address instanceof Mailbox) {
            Mailbox mailbox = (Mailbox)address;
            String name = mailbox.getName();
            if (name != null && name.length() > 0) {
                name = DecoderUtil.decodeEncodedWords((String)name, (DecodeMonitor)DecodeMonitor.SILENT);
                return name + " <" + mailbox.getAddress() + ">";
            }
            return mailbox.getAddress();
        }
        return address.toString();
    }

    public void preamble(InputStream is) throws MimeException, IOException {
    }

    public void raw(InputStream is) throws MimeException, IOException {
    }

    public void startBodyPart() throws MimeException {
        try {
            this.handler.startElement("div", "class", "email-entry");
            this.handler.startElement("p");
        }
        catch (SAXException e) {
            throw new MimeException((Throwable)e);
        }
    }

    public void startHeader() throws MimeException {
    }

    public void startMultipart(BodyDescriptor descr) throws MimeException {
        this.inPart = true;
    }

    private String stripOutFieldPrefix(Field field, String fieldname) {
        String temp = field.getRaw().toString();
        int loc = fieldname.length();
        while (temp.charAt(loc) == ' ') {
            ++loc;
        }
        return temp.substring(loc);
    }
}

