/*
 * Decompiled with CFR 0.152.
 */
package de.lwsystems.mailarchive.maildocument;

import org.simpleframework.xml.Attribute;
import org.simpleframework.xml.Root;

@Root(name="archive")
public class PreviousArchive {
    @Attribute(name="hash")
    private final String hash;
    @Attribute(name="name", required=false)
    private String name = null;
    @Attribute(name="date", required=false)
    private String date = null;

    public PreviousArchive(String hash) {
        this.hash = hash;
    }

    public String getHeaderlines() {
        StringBuilder headerLines = new StringBuilder(1024);
        this.appendHeaderlines(headerLines);
        return headerLines.toString();
    }

    public void appendHeaderlines(StringBuilder headerLines) {
        headerLines.append("PreviousHash: ").append(this.getHash());
        if (this.getName() != null) {
            headerLines.append("\r\nPreviousName: ").append(this.getName());
        }
        if (this.getDate() != null) {
            headerLines.append("\r\nPreviousDate: ").append(this.getDate());
        }
        headerLines.append("\r\n");
    }

    public boolean equals(Object obj) {
        boolean equality = false;
        if (obj != null && obj instanceof PreviousArchive) {
            equality = this.getName().equals(((PreviousArchive)obj).getName()) && this.getDate().equals(((PreviousArchive)obj).getDate()) && this.getHash().equals(((PreviousArchive)obj).getHash());
        }
        return equality;
    }

    public int hashCode() {
        int hash = 7;
        hash = 17 * hash + (this.getName() != null ? this.getName().hashCode() : 0);
        hash = 17 * hash + (this.getDate() != null ? this.getDate().hashCode() : 0);
        hash = 17 * hash + (this.getHash() != null ? this.getHash().hashCode() : 0);
        return hash;
    }

    public String getHash() {
        return this.hash;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDate() {
        return this.date;
    }

    public void setDate(String date) {
        this.date = date;
    }
}

