/*
 * Decompiled with CFR 0.152.
 */
package de.lwsystems.mailarchive.remove;

import de.lwsystems.mailarchive.maildocument.RemovedMailDocument;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Stack;

public final class RemoveDocument {
    private static final HashMap<String, RemoveDocument> instance = new HashMap();
    private boolean logDelete = false;
    private Stack<RemovedMailDocument> messageStack = new Stack();

    private RemoveDocument() {
    }

    public boolean isInstanceSet(String mode) {
        return instance.containsKey(mode);
    }

    public boolean existsDocumentInStack(RemovedMailDocument mailDocument) {
        return this.messageStack.search(mailDocument) != -1;
    }

    public static List<RemoveDocument> getAllActiveInstances() {
        ArrayList<RemoveDocument> activeInstances = new ArrayList<RemoveDocument>();
        RemoveDocument.instance.entrySet().forEach(instance -> activeInstances.add((RemoveDocument)instance.getValue()));
        return activeInstances;
    }

    public static RemoveDocument getInstance(String mode) {
        if (!instance.containsKey(mode)) {
            instance.put(mode, new RemoveDocument());
        }
        return instance.get(mode);
    }

    public void reserveDocumentForRemoving(RemovedMailDocument document) {
        this.messageStack.push(document);
    }

    public RemovedMailDocument getDocumentForRemove() {
        return this.messageStack.pop();
    }

    public boolean existsMailForRemove() {
        return this.messageStack.size() > 0;
    }

    public boolean isLogDelete() {
        return this.logDelete;
    }

    public void activateLogDelete() {
        this.logDelete = true;
    }
}

