/*
 * Decompiled with CFR 0.152.
 */
package de.lwsystems.mailarchive.utils;

import java.util.Iterator;
import java.util.NoSuchElementException;

public class ArrayRangeIterator<T>
implements Iterator<T> {
    public static final ArrayRangeIterator<?> EMPTY_ITERATOR = new ArrayRangeIterator(null, 0, 0);
    protected T[] m_array;
    protected int m_offset;
    protected int m_limit;
    private Object[] m_other;
    private Transformer<Object, T> m_transformer;

    private ArrayRangeIterator(T[] array, int start, int limit) {
        this.m_array = array;
        this.m_offset = start;
        this.m_limit = array == null || limit + start < array.length ? limit + start : array.length;
    }

    private <OTHER> ArrayRangeIterator(OTHER[] array, int start, int limit, Transformer<OTHER, T> transformer) {
        this.m_array = null;
        this.m_transformer = transformer;
        this.m_other = array;
        this.m_offset = start;
        this.m_limit = array == null || limit + start < array.length ? limit + start : array.length;
    }

    @Override
    public boolean hasNext() {
        return this.m_offset < this.m_limit;
    }

    @Override
    public T next() {
        if (this.m_offset < this.m_limit) {
            if (this.m_array == null) {
                Object doc = this.m_other[this.m_offset++];
                return this.m_transformer.transform(doc);
            }
            return this.m_array[this.m_offset++];
        }
        throw new NoSuchElementException();
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    public static <T> Iterator<T> buildIterator(T[] array, int start, int limit) {
        if (array == null || array.length < start) {
            return EMPTY_ITERATOR;
        }
        return new ArrayRangeIterator<T>(array, start, limit);
    }

    public static <OTHER, T> Iterator<T> buildIterator(OTHER[] array, int start, int limit, Transformer<OTHER, T> transformer) {
        if (array == null || array.length < start) {
            return EMPTY_ITERATOR;
        }
        return new ArrayRangeIterator<T>(array, start, limit, transformer);
    }

    public static interface Transformer<T1, T2> {
        public T2 transform(T1 var1);
    }
}

