/*
 * Decompiled with CFR 0.152.
 */
package de.lwsystems.mailarchive.utils;

import java.net.JarURLConnection;
import java.util.jar.Manifest;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class BennoVersion {
    private static final Logger LOGGER = LogManager.getLogger(BennoVersion.class);

    public static String archiveVersion() {
        try {
            String archiveClass = "de/lwsystems/mailarchive/bennoarchive/BennoArchive.class";
            JarURLConnection jarConnection = (JarURLConnection)ClassLoader.getSystemResource("de/lwsystems/mailarchive/bennoarchive/BennoArchive.class").openConnection();
            Manifest manifest = jarConnection.getManifest();
            String archiveVersion = manifest.getMainAttributes().getValue("Implementation-Version");
            return archiveVersion;
        }
        catch (Exception e) {
            LOGGER.error("Cannot read bennoarchive version");
            LOGGER.error((Object)e);
            return "2.0.0";
        }
    }

    public static String coreVersion() {
        try {
            String coreClass = "de/lwsystems/mailarchive/Benno.class";
            JarURLConnection jarConnection = (JarURLConnection)ClassLoader.getSystemResource("de/lwsystems/mailarchive/Benno.class").openConnection();
            Manifest manifest = jarConnection.getManifest();
            String coreVersion = manifest.getMainAttributes().getValue("Implementation-Version");
            return coreVersion;
        }
        catch (Exception e) {
            LOGGER.error("Cannot read bennocore version");
            LOGGER.info((Object)e);
            return "2.0.0";
        }
    }

    public static String restVersion() {
        try {
            String restClass = "de/lwsystems/mailarchive/rest/BennoRest.class";
            JarURLConnection jarConnection = (JarURLConnection)ClassLoader.getSystemResource("de/lwsystems/mailarchive/rest/BennoRest.class").openConnection();
            Manifest manifest = jarConnection.getManifest();
            String restVersion = manifest.getMainAttributes().getValue("Implementation-Version");
            return restVersion;
        }
        catch (Exception e) {
            LOGGER.error("Cannot read bennorest version");
            LOGGER.error((Object)e);
            return "2.0.0";
        }
    }
}

