/*
 * Decompiled with CFR 0.152.
 */
package de.lwsystems.mailarchive.utils;

import de.lwsystems.mailarchive.archive.box.IBox;
import de.lwsystems.mailarchive.utils.LWBZip2CompressorInputStream;
import de.lwsystems.mailarchive.utils.LWBZip2CompressorOutputStream;
import de.lwsystems.mailarchive.utils.LWGzipCompressorInputStream;
import de.lwsystems.mailarchive.utils.LWGzipCompressorOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class CompressionUtil {
    public static String getCompressionSuffix(IBox.CompressionType compression) {
        return switch (compression) {
            case IBox.CompressionType.gzip -> ".gz";
            case IBox.CompressionType.bzip2 -> ".bz2";
            default -> "";
        };
    }

    public static OutputStream getOutStream(File file, IBox.CompressionType compression) throws FileNotFoundException, IOException {
        return CompressionUtil.getOutStream(new FileOutputStream(file), compression);
    }

    public static OutputStream getOutStream(OutputStream stream, IBox.CompressionType compression) throws IOException {
        return switch (compression) {
            case IBox.CompressionType.gzip -> new LWGzipCompressorOutputStream(stream);
            case IBox.CompressionType.bzip2 -> new LWBZip2CompressorOutputStream(stream);
            default -> stream;
        };
    }

    public static InputStream getInStream(File file, IBox.CompressionType compression) throws IOException {
        return CompressionUtil.getInStream(new FileInputStream(file), compression);
    }

    public static InputStream getInStream(InputStream stream, IBox.CompressionType compression) throws IOException {
        return switch (compression) {
            case IBox.CompressionType.gzip -> new LWGzipCompressorInputStream(stream);
            case IBox.CompressionType.bzip2 -> new LWBZip2CompressorInputStream(stream);
            default -> stream;
        };
    }

    public static InputStream getInStream(File file) throws FileNotFoundException, IOException {
        String filename = file.getName();
        IBox.CompressionType compression = filename.endsWith(".bz2") ? IBox.CompressionType.bzip2 : (filename.endsWith(".gz") ? IBox.CompressionType.gzip : IBox.CompressionType.none);
        return CompressionUtil.getInStream(file, compression);
    }
}

