/*
 * Decompiled with CFR 0.152.
 */
package de.lwsystems.mailarchive.utils;

import de.lwsystems.mailarchive.utils.ConversionException;
import org.apache.commons.codec.DecoderException;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.codec.binary.Hex;

public final class ConversionUtil {
    public static final char[] HEXDIGITS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};

    private ConversionUtil() throws Exception {
        throw new Exception();
    }

    public static String fromIntToHex(int integer) {
        Object temp = Integer.toHexString(integer).toUpperCase();
        if (((String)temp).length() == 0) {
            temp = "00";
        }
        if (((String)temp).length() % 2 != 0) {
            temp = "0" + (String)temp;
        }
        return temp;
    }

    public static int fromHexToInt(String hexString) {
        if (hexString == null || hexString.length() == 0) {
            return 0;
        }
        return Integer.parseInt(hexString, 16);
    }

    public static String fromBytesToHex(byte[] bytes) {
        String hexString = bytes == null ? "" : new String(Hex.encodeHex((byte[])bytes, (boolean)false));
        return hexString;
    }

    public static byte[] fromHexToBytes(String hexString) throws ConversionException {
        byte[] bytes;
        try {
            bytes = hexString == null ? new byte[]{} : Hex.decodeHex((char[])hexString.toCharArray());
        }
        catch (DecoderException ex) {
            throw new ConversionException("Conversion from hex failed", (Exception)((Object)ex));
        }
        return bytes;
    }

    public static String fromBytesToB64(byte[] bytes) {
        return Base64.encodeBase64URLSafeString((byte[])bytes);
    }

    public static byte[] fromB64ToBytes(String hexString) {
        return Base64.decodeBase64((String)hexString);
    }
}

