/*
 * Decompiled with CFR 0.152.
 */
package de.lwsystems.mailarchive.utils;

import java.io.BufferedReader;
import java.io.IOException;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class JournalReaderTools {
    public static Optional<String> getFirstBennoIdInJournal(BufferedReader journal) throws IOException {
        if (journal != null) {
            return JournalReaderTools.findBennoIdInBufferedReader(journal);
        }
        return Optional.empty();
    }

    private static Optional<String> findBennoIdInBufferedReader(BufferedReader journal) throws IOException {
        String bennoYearIdRegex = "\\d{4}:[0-9_A-F]{60,70}";
        String bennoIdRegex = "[0-9_A-F]{60,70}";
        Pattern bennoIdPattern = Pattern.compile("[0-9_A-F]{60,70}");
        Pattern bennoYearIdPattern = Pattern.compile("\\d{4}:[0-9_A-F]{60,70}");
        String journalLine = null;
        while ((journalLine = journal.readLine()) != null) {
            Matcher bennoIdMatches = bennoIdPattern.matcher(journalLine);
            Matcher bennoYearIdMatches = bennoYearIdPattern.matcher(journalLine);
            if (!bennoIdMatches.find() && !bennoYearIdMatches.find()) continue;
            return Optional.ofNullable(bennoIdMatches.group());
        }
        return Optional.empty();
    }
}

