/*
 * Decompiled with CFR 0.152.
 */
package de.lwsystems.mailarchive.utils;

import de.lwsystems.mailarchive.archive.box.BoxGeneratorState;
import de.lwsystems.mailarchive.archive.container.SystemContainer;
import de.lwsystems.mailarchive.config.BennoConfig;
import de.lwsystems.mailarchive.utils.BennoXmlDateTransform;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.net.URL;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.apache.commons.io.input.ReaderInputStream;
import org.simpleframework.xml.convert.AnnotationStrategy;
import org.simpleframework.xml.core.Persister;
import org.simpleframework.xml.filter.Filter;
import org.simpleframework.xml.filter.PlatformFilter;
import org.simpleframework.xml.strategy.Strategy;
import org.simpleframework.xml.strategy.TreeStrategy;
import org.simpleframework.xml.transform.Matcher;
import org.simpleframework.xml.transform.Transform;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;

public class PersistenceUtil {
    public static void main(String[] args) throws Exception {
        PersistenceUtil.createPersister().write((Object)PersistenceUtil.readBennoConfig(Paths.get(args[0], new String[0]).toFile()), (OutputStream)System.out);
    }

    public static Persister createPersister() {
        return new Persister((Strategy)new AnnotationStrategy((Strategy)new TreeStrategy("type", "count")), (Filter)new PlatformFilter(new HashMap()), new Matcher(){

            public Transform match(Class type) throws Exception {
                if (type == Date.class) {
                    return new BennoXmlDateTransform();
                }
                return null;
            }
        });
    }

    public static BennoConfig readBennoConfig(File configFile) throws Exception {
        return PersistenceUtil.doRead(PersistenceUtil.migrateConfig(new FileInputStream(configFile)));
    }

    public static BennoConfig readBennoConfig(URL configFile) throws Exception {
        return PersistenceUtil.doRead(PersistenceUtil.migrateConfig(configFile.openStream()));
    }

    public static BennoConfig readBennoConfig(String configString) throws Exception {
        ReaderInputStream inConfigXml = new ReaderInputStream((Reader)new StringReader(configString), "UTF-8");
        return PersistenceUtil.doRead(PersistenceUtil.migrateConfig((InputStream)inConfigXml));
    }

    public static BoxGeneratorState readBoxGeneratorState(File boxStateFile) throws Exception {
        return (BoxGeneratorState)PersistenceUtil.createPersister().read(BoxGeneratorState.class, PersistenceUtil.migrateConfig(new FileInputStream(boxStateFile)));
    }

    public static BoxGeneratorState readBoxGeneratorState(URL resource) throws Exception {
        return (BoxGeneratorState)PersistenceUtil.createPersister().read(BoxGeneratorState.class, PersistenceUtil.migrateConfig(resource.openStream()));
    }

    private static BennoConfig doRead(InputStream source) throws Exception {
        BennoConfig bennoConfig = (BennoConfig)PersistenceUtil.createPersister().read(BennoConfig.class, source);
        SystemContainer.addSystemContainer(bennoConfig);
        return bennoConfig;
    }

    private static InputStream migrateConfig(InputStream inConfigXml) {
        try {
            Resource[] resources = new PathMatchingResourcePatternResolver().getResources("classpath:config-transformation/*.xsl");
            InputStream currentConfigInput = inConfigXml;
            Comparator<Resource> comparator = new Comparator<Resource>(){

                @Override
                public int compare(Resource o1, Resource o2) {
                    return o1.getFilename().compareTo(o2.getFilename());
                }
            };
            Arrays.sort(resources, comparator);
            ByteArrayOutputStream outXml = null;
            for (Resource resource : resources) {
                outXml = new ByteArrayOutputStream();
                try {
                    Transformer.transform(currentConfigInput, outXml, resource.getInputStream());
                }
                catch (TransformerException e) {
                    throw new RuntimeException(e);
                }
                currentConfigInput = new ByteArrayInputStream(outXml.toByteArray());
            }
            return currentConfigInput;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static class Transformer {
        public static void transform(InputStream inXml, OutputStream outXml, InputStream xslt) throws TransformerException, TransformerConfigurationException, FileNotFoundException, IOException {
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            javax.xml.transform.Transformer transformer = transformerFactory.newTransformer(new StreamSource(xslt));
            transformer.transform(new StreamSource(inXml), new StreamResult(outXml));
        }
    }
}

