#!/bin/sh
# preinst script for benno-archive
#

set -e

# summary of how this script can be called:
#        * <new-preinst> `install'
#        * <new-preinst> `install' <old-version>
#        * <new-preinst> `upgrade' <old-version>
#        * <old-preinst> `abort-upgrade' <new-version>
# for details, see http://www.debian.org/doc/debian-policy/ or
# the debian-policy package


case "$1" in
    install|upgrade)
        [ -z "$BENNO_GROUP" ] && BENNO_GROUP=benno
        [ -z "$BENNO_USER" ] && BENNO_USER=benno
        [ -z "$BENNO_ETC" ] && BENNO_ETC=/etc/benno

        test -d $BENNO_ETC || mkdir $BENNO_ETC

        # 5. adjust file and directory permissions
        if ! dpkg-statoverride --list $BENNO_ETC >/dev/null
        then
            #chown -R $BENNO_USER:$BENNO_GROUP $BENNO_ETC
            #chmod u=rwx,g=rwx,o= $BENNO_ETC
            chown -R root:$BENNO_GROUP $BENNO_ETC
            chmod u=rwx,g=rx,o= $BENNO_ETC
        fi
    ;;

    abort-upgrade)
    ;;

    *)
        echo "preinst called with unknown argument \`$1'" >&2
        exit 1
    ;;
esac

# dh_installdeb will replace this with shell code automatically
# generated by other debhelper scripts.



exit 0
