/*
 * Decompiled with CFR 0.152.
 */
package org.simplejavamail.api.email.config;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.Nullable;
import org.simplejavamail.internal.util.MiscUtil;

public class DkimConfig
implements Serializable {
    private static final long serialVersionUID = 1234567L;
    private final byte[] dkimPrivateKeyData;
    private final String dkimSigningDomain;
    private final String dkimSelector;
    @Nullable
    private final Boolean useLengthParam;
    @Nullable
    private final Set<String> excludedHeadersFromDkimDefaultSigningList;
    @Nullable
    private final Canonicalization headerCanonicalization;
    @Nullable
    private final Canonicalization bodyCanonicalization;
    @Nullable
    private final String signingAlgorithm;

    DkimConfig(byte[] dkimPrivateKeyData, String dkimSigningDomain, String dkimSelector, Boolean useLengthParam, @Nullable Set<String> excludedHeadersFromDkimDefaultSigningList, @Nullable Canonicalization headerCanonicalization, @Nullable Canonicalization bodyCanonicalization, @Nullable String signingAlgorithm) {
        this.dkimPrivateKeyData = (byte[])dkimPrivateKeyData.clone();
        this.dkimSigningDomain = dkimSigningDomain;
        this.dkimSelector = dkimSelector;
        this.useLengthParam = useLengthParam;
        this.excludedHeadersFromDkimDefaultSigningList = excludedHeadersFromDkimDefaultSigningList;
        this.headerCanonicalization = headerCanonicalization;
        this.bodyCanonicalization = bodyCanonicalization;
        this.signingAlgorithm = signingAlgorithm;
    }

    public byte[] getDkimPrivateKeyData() {
        return (byte[])this.dkimPrivateKeyData.clone();
    }

    public static DkimConfigBuilder builder() {
        return new DkimConfigBuilder();
    }

    public String toString() {
        return "DkimConfig(dkimSigningDomain=" + this.getDkimSigningDomain() + ", dkimSelector=" + this.getDkimSelector() + ", useLengthParam=" + this.getUseLengthParam() + ", excludedHeadersFromDkimDefaultSigningList=" + this.getExcludedHeadersFromDkimDefaultSigningList() + ", headerCanonicalization=" + (Object)((Object)this.getHeaderCanonicalization()) + ", bodyCanonicalization=" + (Object)((Object)this.getBodyCanonicalization()) + ", signingAlgorithm=" + this.getSigningAlgorithm() + ")";
    }

    public String getDkimSigningDomain() {
        return this.dkimSigningDomain;
    }

    public String getDkimSelector() {
        return this.dkimSelector;
    }

    @Nullable
    public Boolean getUseLengthParam() {
        return this.useLengthParam;
    }

    @Nullable
    public Set<String> getExcludedHeadersFromDkimDefaultSigningList() {
        return this.excludedHeadersFromDkimDefaultSigningList;
    }

    @Nullable
    public Canonicalization getHeaderCanonicalization() {
        return this.headerCanonicalization;
    }

    @Nullable
    public Canonicalization getBodyCanonicalization() {
        return this.bodyCanonicalization;
    }

    @Nullable
    public String getSigningAlgorithm() {
        return this.signingAlgorithm;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DkimConfig)) {
            return false;
        }
        DkimConfig other = (DkimConfig)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Boolean this$useLengthParam = this.getUseLengthParam();
        Boolean other$useLengthParam = other.getUseLengthParam();
        if (this$useLengthParam == null ? other$useLengthParam != null : !((Object)this$useLengthParam).equals(other$useLengthParam)) {
            return false;
        }
        if (!Arrays.equals(this.getDkimPrivateKeyData(), other.getDkimPrivateKeyData())) {
            return false;
        }
        String this$dkimSigningDomain = this.getDkimSigningDomain();
        String other$dkimSigningDomain = other.getDkimSigningDomain();
        if (this$dkimSigningDomain == null ? other$dkimSigningDomain != null : !this$dkimSigningDomain.equals(other$dkimSigningDomain)) {
            return false;
        }
        String this$dkimSelector = this.getDkimSelector();
        String other$dkimSelector = other.getDkimSelector();
        if (this$dkimSelector == null ? other$dkimSelector != null : !this$dkimSelector.equals(other$dkimSelector)) {
            return false;
        }
        Set<String> this$excludedHeadersFromDkimDefaultSigningList = this.getExcludedHeadersFromDkimDefaultSigningList();
        Set<String> other$excludedHeadersFromDkimDefaultSigningList = other.getExcludedHeadersFromDkimDefaultSigningList();
        if (this$excludedHeadersFromDkimDefaultSigningList == null ? other$excludedHeadersFromDkimDefaultSigningList != null : !((Object)this$excludedHeadersFromDkimDefaultSigningList).equals(other$excludedHeadersFromDkimDefaultSigningList)) {
            return false;
        }
        Canonicalization this$headerCanonicalization = this.getHeaderCanonicalization();
        Canonicalization other$headerCanonicalization = other.getHeaderCanonicalization();
        if (this$headerCanonicalization == null ? other$headerCanonicalization != null : !((Object)((Object)this$headerCanonicalization)).equals((Object)other$headerCanonicalization)) {
            return false;
        }
        Canonicalization this$bodyCanonicalization = this.getBodyCanonicalization();
        Canonicalization other$bodyCanonicalization = other.getBodyCanonicalization();
        if (this$bodyCanonicalization == null ? other$bodyCanonicalization != null : !((Object)((Object)this$bodyCanonicalization)).equals((Object)other$bodyCanonicalization)) {
            return false;
        }
        String this$signingAlgorithm = this.getSigningAlgorithm();
        String other$signingAlgorithm = other.getSigningAlgorithm();
        return !(this$signingAlgorithm == null ? other$signingAlgorithm != null : !this$signingAlgorithm.equals(other$signingAlgorithm));
    }

    protected boolean canEqual(Object other) {
        return other instanceof DkimConfig;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $useLengthParam = this.getUseLengthParam();
        result = result * 59 + ($useLengthParam == null ? 43 : ((Object)$useLengthParam).hashCode());
        result = result * 59 + Arrays.hashCode(this.getDkimPrivateKeyData());
        String $dkimSigningDomain = this.getDkimSigningDomain();
        result = result * 59 + ($dkimSigningDomain == null ? 43 : $dkimSigningDomain.hashCode());
        String $dkimSelector = this.getDkimSelector();
        result = result * 59 + ($dkimSelector == null ? 43 : $dkimSelector.hashCode());
        Set<String> $excludedHeadersFromDkimDefaultSigningList = this.getExcludedHeadersFromDkimDefaultSigningList();
        result = result * 59 + ($excludedHeadersFromDkimDefaultSigningList == null ? 43 : ((Object)$excludedHeadersFromDkimDefaultSigningList).hashCode());
        Canonicalization $headerCanonicalization = this.getHeaderCanonicalization();
        result = result * 59 + ($headerCanonicalization == null ? 43 : ((Object)((Object)$headerCanonicalization)).hashCode());
        Canonicalization $bodyCanonicalization = this.getBodyCanonicalization();
        result = result * 59 + ($bodyCanonicalization == null ? 43 : ((Object)((Object)$bodyCanonicalization)).hashCode());
        String $signingAlgorithm = this.getSigningAlgorithm();
        result = result * 59 + ($signingAlgorithm == null ? 43 : $signingAlgorithm.hashCode());
        return result;
    }

    public static class DkimConfigBuilder {
        private byte[] dkimPrivateKeyData;
        private String dkimSigningDomain;
        private String dkimSelector;
        @Nullable
        Boolean useLengthParam;
        @Nullable
        private Set<String> excludedHeadersFromDkimDefaultSigningList;
        @Nullable
        private Canonicalization headerCanonicalization;
        @Nullable
        private Canonicalization bodyCanonicalization;
        @Nullable
        private String signingAlgorithm;

        public DkimConfigBuilder dkimPrivateKeyPath(String dkimPrivateKeyFile) {
            return this.dkimPrivateKeyPath(new File(dkimPrivateKeyFile));
        }

        public DkimConfigBuilder dkimPrivateKeyPath(File dkimPrivateKeyFile) {
            try (FileInputStream dkimPrivateKeyInputStream = new FileInputStream(dkimPrivateKeyFile);){
                this.dkimPrivateKeyData(dkimPrivateKeyInputStream);
            }
            catch (IOException e) {
                throw new IllegalStateException(String.format("error reading DKIM private key file[%s]", dkimPrivateKeyFile), e);
            }
            return this;
        }

        public DkimConfigBuilder dkimPrivateKeyData(InputStream dkimPrivateKeyInputStream) {
            try {
                this.dkimPrivateKeyData(MiscUtil.readInputStreamToBytes(dkimPrivateKeyInputStream));
            }
            catch (IOException e) {
                throw new IllegalStateException("error reading DKIM private key inputstream", e);
            }
            return this;
        }

        public DkimConfigBuilder dkimPrivateKeyData(String dkimPrivateKeyData) {
            this.dkimPrivateKeyData(dkimPrivateKeyData.getBytes(StandardCharsets.UTF_8));
            return this;
        }

        public DkimConfigBuilder dkimPrivateKeyData(byte[] dkimPrivateKeyData) {
            this.dkimPrivateKeyData = (byte[])dkimPrivateKeyData.clone();
            return this;
        }

        public DkimConfigBuilder dkimSigningDomain(String dkimSigningDomain) {
            this.dkimSigningDomain = dkimSigningDomain;
            return this;
        }

        public DkimConfigBuilder dkimSelector(String dkimSelector) {
            this.dkimSelector = dkimSelector;
            return this;
        }

        public DkimConfigBuilder useLengthParam(@Nullable Boolean useLengthParam) {
            this.useLengthParam = useLengthParam;
            return this;
        }

        public DkimConfigBuilder excludedHeadersFromDkimDefaultSigningList(@Nullable Set<String> excludedHeadersFromDkimDefaultSigningList) {
            this.excludedHeadersFromDkimDefaultSigningList = excludedHeadersFromDkimDefaultSigningList;
            return this;
        }

        public DkimConfigBuilder excludedHeadersFromDkimDefaultSigningList(String ... excludedHeadersFromDkimDefaultSigningList) {
            this.excludedHeadersFromDkimDefaultSigningList = new HashSet<String>(Arrays.asList(excludedHeadersFromDkimDefaultSigningList));
            return this;
        }

        public DkimConfigBuilder headerCanonicalization(@Nullable Canonicalization headerCanonicalization) {
            this.headerCanonicalization = headerCanonicalization;
            return this;
        }

        public DkimConfigBuilder bodyCanonicalization(@Nullable Canonicalization bodyCanonicalization) {
            this.bodyCanonicalization = bodyCanonicalization;
            return this;
        }

        public DkimConfigBuilder signingAlgorithm(@Nullable String signingAlgorithm) {
            this.signingAlgorithm = signingAlgorithm;
            return this;
        }

        public DkimConfig build() {
            return new DkimConfig(this.dkimPrivateKeyData, this.dkimSigningDomain, this.dkimSelector, this.useLengthParam, this.excludedHeadersFromDkimDefaultSigningList, this.headerCanonicalization, this.bodyCanonicalization, this.signingAlgorithm);
        }

        public String toString() {
            return "DkimConfig.DkimConfigBuilder(dkimPrivateKeyData=" + Arrays.toString(this.dkimPrivateKeyData) + ", dkimSigningDomain=" + this.dkimSigningDomain + ", dkimSelector=" + this.dkimSelector + ", useLengthParam=" + this.useLengthParam + ", excludedHeadersFromDkimDefaultSigningList=" + this.excludedHeadersFromDkimDefaultSigningList + ", headerCanonicalization=" + (Object)((Object)this.headerCanonicalization) + ", bodyCanonicalization=" + (Object)((Object)this.bodyCanonicalization) + ", signingAlgorithm=" + this.signingAlgorithm + ")";
        }
    }

    public static enum Canonicalization {
        SIMPLE,
        RELAXED;

    }
}

