/*
 * Decompiled with CFR 0.152.
 */
package org.simplejavamail.api.internal.general;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.simplejavamail.api.internal.general.MessageHeader;

public class HeadersToIgnoreWhenParsingExternalEmails {
    private static final List<MessageHeader> HEADERS_TO_IGNORE_CASE_INSENSITIVE = Arrays.asList(MessageHeader.RECEIVED, MessageHeader.RESENT_DATE, MessageHeader.RESENT_FROM, MessageHeader.RESENT_SENDER, MessageHeader.RESENT_TO, MessageHeader.RESENT_CC, MessageHeader.RESENT_BCC, MessageHeader.DATE, MessageHeader.FROM, MessageHeader.SENDER, MessageHeader.TO, MessageHeader.CC, MessageHeader.BCC, MessageHeader.SUBJECT, MessageHeader.CONTENT_MD5, MessageHeader.CONTENT_LENGTH, MessageHeader.COLON, MessageHeader.STATUS, MessageHeader.CONTENT_DISPOSITION, MessageHeader.SIZE, MessageHeader.FILENAME, MessageHeader.CONTENT_ID, MessageHeader.NAME, MessageHeader.RESENT_MESSAGE_ID, MessageHeader.COMMENTS, MessageHeader.KEYWORDS, MessageHeader.ERRORS_TO, MessageHeader.MIME_VERSION, MessageHeader.CONTENT_TYPE, MessageHeader.CONTENT_TRANSFER_ENCODING, MessageHeader.RESENT_MESSAGE_ID, MessageHeader.REPLY_TO);
    private static final List<MessageHeader> HEADERS_TO_IGNORE_CASE_SENSITIVE = Collections.singletonList(MessageHeader.MESSAGE_ID);

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean shouldIgnoreHeader(String headerName) {
        if (HEADERS_TO_IGNORE_CASE_INSENSITIVE.stream().map(MessageHeader::getName).anyMatch(headerName::equalsIgnoreCase)) return true;
        if (!HEADERS_TO_IGNORE_CASE_SENSITIVE.stream().map(MessageHeader::getName).anyMatch(headerName::equals)) return false;
        return true;
    }
}

