/*
 * Decompiled with CFR 0.152.
 */
package de.lwsystems.mailarchive.bennoimport.core.auth;

import de.lwsystems.mailarchive.bennoimport.core.auth.HttpClientInterface;
import de.lwsystems.mailarchive.bennoimport.core.auth.RestAuthResponse;
import de.lwsystems.mailarchive.bennoimport.core.client.HttpClientFactory;
import de.lwsystems.mailarchive.bennoimport.core.config.yaml.httpclient.HttpClient;
import de.lwsystems.mailarchive.bennoimport.core.exceptions.HttpClientException;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.jetty.client.HttpClientTransport;
import org.eclipse.jetty.client.api.ContentResponse;
import org.eclipse.jetty.client.dynamic.HttpClientTransportDynamic;
import org.eclipse.jetty.io.ClientConnectionFactory;
import org.eclipse.jetty.io.ClientConnector;
import org.eclipse.jetty.util.ssl.SslContextFactory;

public class RestCall {
    private static final Logger LOGGER = LogManager.getLogger(RestCall.class);
    private final HttpClientFactory clientFactory;
    private final HttpClient httpClientConfig;

    public RestCall(HttpClientFactory clientFactory, HttpClient httpClientConfig) {
        this.clientFactory = clientFactory;
        this.httpClientConfig = httpClientConfig;
    }

    public RestAuthResponse getRequest(Map<String, String> requestHeader, Map<String, String> queryParams, String targetUrl) throws HttpClientException {
        RestAuthResponse restAuthResponse;
        block9: {
            HttpClientInterface client = this.clientFactory.createClient(this.createHttpClient(), this.httpClientConfig.getConnectTimeoutInMs());
            try {
                ContentResponse contentResponse = client.executeGetRequest(targetUrl, requestHeader, queryParams, ContentResponse.class);
                restAuthResponse = this.handleResponse(contentResponse, requestHeader);
                if (client == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (client != null) {
                        try {
                            client.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (HttpClientException ex) {
                    throw new HttpClientException("HTTP GET request to " + targetUrl + " failed: " + ex.getMessage(), ex);
                }
                catch (Exception ex) {
                    throw new HttpClientException("Unexpected GET request error to " + targetUrl + " " + ex.getMessage(), ex);
                }
            }
            client.close();
        }
        return restAuthResponse;
    }

    public RestAuthResponse postRequest(Map<String, String> requestHeader, Map<String, String> queryParams, String targetUrl) throws HttpClientException {
        RestAuthResponse restAuthResponse;
        block9: {
            HttpClientInterface client = this.clientFactory.createClient(this.createHttpClient(), this.httpClientConfig.getConnectTimeoutInMs());
            try {
                ContentResponse contentResponse = client.executePostRequest(targetUrl, requestHeader, queryParams, ContentResponse.class);
                restAuthResponse = this.handleResponse(contentResponse, requestHeader);
                if (client == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (client != null) {
                        try {
                            client.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (HttpClientException ex) {
                    throw new HttpClientException("HTTP POST request to " + targetUrl + " failed: " + ex.getMessage(), ex);
                }
                catch (Exception ex) {
                    throw new HttpClientException("Unexpected POST request error to " + targetUrl + ": " + ex.getMessage(), ex);
                }
            }
            client.close();
        }
        return restAuthResponse;
    }

    public RestAuthResponse putRequest(Map<String, String> requestHeader, String targetUrl, byte[] mailBytes) throws HttpClientException {
        RestAuthResponse restAuthResponse;
        block9: {
            HttpClientInterface client = this.clientFactory.createClient(this.createHttpClient(), this.httpClientConfig.getConnectTimeoutInMs());
            try {
                ContentResponse contentResponse = client.executePutRequest(targetUrl, requestHeader, mailBytes, ContentResponse.class);
                restAuthResponse = this.handleResponse(contentResponse, requestHeader);
                if (client == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (client != null) {
                        try {
                            client.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (HttpClientException ex) {
                    throw new HttpClientException("HTTP PUT request to " + targetUrl + " failed : " + ex.getMessage(), ex);
                }
                catch (Exception ex) {
                    throw new HttpClientException("Unexpected PUT request error to " + targetUrl + " : " + ex.getMessage(), ex);
                }
            }
            client.close();
        }
        return restAuthResponse;
    }

    private org.eclipse.jetty.client.HttpClient createHttpClient() {
        if (this.httpClientConfig.isVerifyCertificate()) {
            LOGGER.debug("Creating HttpClient for request with certificate verification");
            return new org.eclipse.jetty.client.HttpClient();
        }
        LOGGER.debug("Creating HttpClient for request without certificate verification");
        return new org.eclipse.jetty.client.HttpClient((HttpClientTransport)this.getHttpClientTransportDynamic());
    }

    private HttpClientTransportDynamic getHttpClientTransportDynamic() {
        SslContextFactory.Client sslContextFactory = new SslContextFactory.Client();
        sslContextFactory.setTrustAll(true);
        ClientConnector clientConnector = new ClientConnector();
        clientConnector.setSslContextFactory(sslContextFactory);
        return new HttpClientTransportDynamic(clientConnector, new ClientConnectionFactory.Info[0]);
    }

    private RestAuthResponse handleResponse(ContentResponse contentResponse, Map<String, String> headers) {
        int status = contentResponse.getStatus();
        if (status >= 200 && status < 300) {
            return new RestAuthResponse(headers, contentResponse);
        }
        throw new HttpClientException("Request failed with status: " + status);
    }
}

