/*
 * Decompiled with CFR 0.152.
 */
package de.lwsystems.mailarchive.bennoimport.core.auth;

import de.lwsystems.mailarchive.bennoimport.core.auth.HttpClientInterface;
import de.lwsystems.mailarchive.bennoimport.core.exceptions.HttpClientException;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.jetty.client.HttpClient;
import org.eclipse.jetty.client.api.ContentResponse;
import org.eclipse.jetty.client.api.Request;
import org.eclipse.jetty.client.util.BytesRequestContent;
import org.eclipse.jetty.client.util.FormRequestContent;
import org.eclipse.jetty.http.HttpFields;
import org.eclipse.jetty.util.Fields;

public class RestHttpClient
implements HttpClientInterface,
AutoCloseable {
    private static final Logger LOGGER = LogManager.getLogger(RestHttpClient.class);
    private final HttpClient httpClient;

    public RestHttpClient(HttpClient httpClient, long timeOut) {
        this.httpClient = httpClient;
        this.httpClient.setConnectTimeout(timeOut);
        this.start();
    }

    @Override
    public void start() {
        if (!this.httpClient.isStarted()) {
            try {
                this.httpClient.start();
            }
            catch (Exception ex) {
                throw new HttpClientException("Could not start HttpClient", ex);
            }
        }
    }

    @Override
    public void close() {
        if (this.httpClient.isStarted()) {
            try {
                this.httpClient.stop();
            }
            catch (Exception ex) {
                LOGGER.error("Could not stop HttpClient", (Throwable)ex);
                throw new HttpClientException("Could not stop HttpClient", ex);
            }
        }
    }

    @Override
    public <T> T executeGetRequest(String targetUrl, Map<String, String> requestHeader, Map<String, String> queryParams, Class<T> responseType) throws HttpClientException {
        return this.executeRequest(targetUrl, HttpMethod.GET, requestHeader, queryParams, responseType);
    }

    @Override
    public <T> T executePostRequest(String targetUrl, Map<String, String> requestHeader, Map<String, String> queryParams, Class<T> responseType) throws HttpClientException {
        return this.executeRequest(targetUrl, HttpMethod.POST, requestHeader, queryParams, responseType);
    }

    @Override
    public <T> T executePutRequest(String targetUrl, Map<String, String> requestHeader, byte[] mailBytes, Class<T> responseType) throws HttpClientException {
        return this.executeRequest(targetUrl, HttpMethod.PUT, requestHeader, null, mailBytes, responseType);
    }

    private <T> T executeRequest(String targetUrl, HttpMethod method, Map<String, String> requestHeader, Map<String, String> queryParams, Class<T> responseType) {
        return this.executeRequest(targetUrl, method, requestHeader, queryParams, null, responseType);
    }

    private <T> T executeRequest(String targetUrl, HttpMethod method, Map<String, String> requestHeader, Map<String, String> queryParams, byte[] requestBody, Class<T> responseType) {
        try {
            Request request = this.createRequest(targetUrl, method, requestHeader);
            if (queryParams != null && !queryParams.isEmpty()) {
                if (method == HttpMethod.GET) {
                    queryParams.forEach((arg_0, arg_1) -> ((Request)request).param(arg_0, arg_1));
                } else if (method == HttpMethod.POST) {
                    Fields fields = new Fields();
                    queryParams.forEach((arg_0, arg_1) -> ((Fields)fields).put(arg_0, arg_1));
                    request.body((Request.Content)new FormRequestContent(fields));
                }
            }
            if (requestBody != null && method == HttpMethod.PUT) {
                request.body((Request.Content)new BytesRequestContent((byte[][])new byte[][]{requestBody}));
            }
            ContentResponse response = request.send();
            return responseType.cast(response);
        }
        catch (Exception ex) {
            this.handleException(ex, method);
            return null;
        }
    }

    private Request createRequest(String targetUrl, HttpMethod method, Map<String, String> requestHeader) {
        Request request = this.httpClient.newRequest(targetUrl).method(method.toString());
        request.headers(httpFields -> requestHeader.forEach((arg_0, arg_1) -> ((HttpFields.Mutable)httpFields).add(arg_0, arg_1)));
        return request;
    }

    private void handleException(Exception ex, HttpMethod method) {
        if (ex instanceof InterruptedException) {
            Thread.currentThread().interrupt();
            LOGGER.error("Thread interrupted: {}", (Object)ex.getMessage());
            throw new HttpClientException("Thread interrupted: " + ex.getMessage());
        }
        LOGGER.error("Could not execute {} request: {}", (Object)method, (Object)ex.getMessage());
        throw new HttpClientException("Could not execute " + method + " request: " + ex.getMessage());
    }

    public static enum HttpMethod {
        GET,
        POST,
        PUT,
        DELETE;

    }
}

