/*
 * Decompiled with CFR 0.152.
 */
package de.lwsystems.mailarchive.bennoimport.core.services;

import de.lwsystems.mailarchive.bennoimport.core.services.IJournalMailHandlingService;
import java.io.IOException;
import java.io.InputStream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.simplejavamail.api.email.AttachmentResource;
import org.simplejavamail.api.email.Email;
import org.simplejavamail.converter.EmailConverter;

public class MicrosoftJournalMailHandlingService
implements IJournalMailHandlingService {
    private static final Logger LOGGER = LogManager.getLogger(MicrosoftJournalMailHandlingService.class);

    @Override
    public InputStream getMailFromJournalMail(InputStream journalMailStream) throws IOException {
        Email email = EmailConverter.emlToEmail((InputStream)journalMailStream);
        if (email.getHeaders().containsKey("X-MS-Journal-Report")) {
            if (email.getAttachments().size() == 1) {
                LOGGER.debug("The mail attached to the journal mail could be loaded.");
                return ((AttachmentResource)email.getAttachments().get(0)).getDataSource().getInputStream();
            }
            LOGGER.warn("The header X-MS-Journal-Report exists, but the number of attachments is != 1. In this case, the sent mail will be forwarded.");
        } else {
            LOGGER.warn("X-MS-Journal-Report header doesn't exist in sent mail. In this case, the sent mail will be forwarded.");
        }
        return journalMailStream;
    }
}

