/*
 * Decompiled with CFR 0.152.
 */
package de.lwsystems.mailarchive.bennoimport.core.services;

import de.lwsystems.mailarchive.bennoimport.core.exceptions.FileIsAlreadyWrittenException;
import de.lwsystems.mailarchive.bennoimport.core.models.Container;
import de.lwsystems.mailarchive.bennoimport.core.models.Mail;
import de.lwsystems.mailarchive.bennoimport.core.services.IMailWrite;
import de.lwsystems.mailarchive.bennoimport.core.services.IProcessFile;
import de.lwsystems.mailarchive.bennoimport.core.utils.BennoImportUtils;
import de.lwsystems.mailarchive.bennoimport.core.utils.FileCheckerUtils;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.security.InvalidParameterException;
import java.util.ArrayList;
import java.util.Arrays;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ProcessFile
implements IProcessFile {
    private static final Logger LOGGER = LogManager.getLogger(ProcessFile.class);
    private static final String FALLBACK_CONTAINER_NAME = "no-container";
    private final String mailHeader;
    private final String[] containerBlacklist;
    private final IMailWrite writeMail;
    private final int waitTime;
    private final boolean saveWithGwHeader;

    public ProcessFile(IMailWrite writeMail, String[] containerBlacklist, String mailHeader, int waitTime, boolean saveWithGwHeader) {
        this.writeMail = writeMail;
        this.containerBlacklist = containerBlacklist;
        this.mailHeader = mailHeader;
        this.waitTime = waitTime;
        this.saveWithGwHeader = saveWithGwHeader;
    }

    @Override
    public String processFile(Mail mail, String path, String[] mailHeaders, String mailChecksum) throws FileIsAlreadyWrittenException, IOException {
        if (!this.saveWithGwHeader) {
            String fileName = this.fileWithoutGwHeader(path, mailChecksum);
            return this.saveMailFromFullMail(path, mail, fileName);
        }
        String fileName = this.hasBennoGwHeaders(mailHeaders) ? this.fileWithBennoGwHeader(mail, path, mailHeaders, mailChecksum) : this.fileWithStandardGwHeader(path, mailChecksum);
        return this.saveMailFromParts(path, mail, fileName);
    }

    @Override
    public ByteArrayOutputStream processStreamFromParts(Mail mail) throws IOException {
        return this.writeMail.writeMailIntoStreamFromParts(mail);
    }

    @Override
    public String processFile(Mail mail, String path, String mailChecksum) throws FileIsAlreadyWrittenException, IOException, InvalidParameterException {
        String fileName = "";
        fileName = mail.getBennoGwHeaderList() != null ? this.fileWithBennoGwHeader(mail, path, mail.getBennoGwHeaderList().toArray(new String[0]), mailChecksum) : this.fileWithoutGwHeader(path, mailChecksum);
        return this.saveMailFromFullMail(path, mail, fileName);
    }

    @Override
    public ByteArrayOutputStream processStreamFullFromFullMail(Mail mail) throws IOException {
        return this.writeMail.writeMailIntoStreamFullMail(mail);
    }

    private String fileWithBennoGwHeader(Mail mail, String path, String[] bennoGwHeaders, String checksum) throws FileIsAlreadyWrittenException, IOException {
        Container container = this.createContainer(bennoGwHeaders, this.containerBlacklist, this.mailHeader);
        LOGGER.trace("Container and GW-header object: {}", (Object)container);
        mail.setBennoGwHeaders(container.getHeader());
        LOGGER.debug("Set GW-headers: {},  for: {}", (Object)container.getHeader(), (Object)checksum);
        this.checkIfMailExists(checksum, container.getContainerFileName().toString(), path);
        String fileName = this.generateFileName(checksum, container.getContainerFileName().toString());
        return fileName;
    }

    private String fileWithStandardGwHeader(String path, String checksum) throws FileIsAlreadyWrittenException, IOException {
        this.checkIfMailExists(checksum, FALLBACK_CONTAINER_NAME, path);
        LOGGER.debug("Save file with standard GW-headers: {}", (Object)checksum);
        String fileName = this.generateFileName(checksum, FALLBACK_CONTAINER_NAME);
        return fileName;
    }

    private String fileWithoutGwHeader(String path, String checksum) throws FileIsAlreadyWrittenException, IOException {
        this.checkIfMailExists(checksum, "", path);
        LOGGER.debug("Save file without GW-headers: {}", (Object)checksum);
        String fileName = this.generateFileName(checksum, "");
        return fileName;
    }

    private void checkIfMailExists(String checksum, String fallbackContainerName, String path) throws FileIsAlreadyWrittenException, IOException {
        try {
            boolean fileExists = this.checkIfFileExists(checksum, fallbackContainerName, path);
            if (fileExists) {
                LOGGER.debug("File with checksum: {} already exists in {}", (Object)checksum, (Object)path);
                throw new FileIsAlreadyWrittenException("Mail with checksum " + checksum + " already exists in " + path);
            }
        }
        catch (IOException ex) {
            LOGGER.error("Error while checking if mail with checksum {} exists in {}", (Object)checksum, (Object)path);
            throw ex;
        }
    }

    private boolean hasBennoGwHeaders(String[] bennoGwHeaders) {
        return bennoGwHeaders.length > 0 && (bennoGwHeaders.length > 1 || !bennoGwHeaders[0].isEmpty());
    }

    private Container createContainer(String[] containers, String[] containerBlacklist, String mailHeader) {
        return new Container(new ArrayList<String>(Arrays.asList(containerBlacklist)), new ArrayList<String>(Arrays.asList(containers)), mailHeader);
    }

    private boolean checkIfFileExists(String checksum, String containerName, String path) throws IOException {
        String fileName = BennoImportUtils.setFilename(checksum, containerName);
        return FileCheckerUtils.existsFilePrefixOnSystem(path, fileName);
    }

    private String generateFileName(String checksum, String containerName) {
        String fileName = BennoImportUtils.setFilename(checksum, containerName);
        LOGGER.debug("Name of file is: {}", (Object)fileName);
        return fileName;
    }

    private String saveMailFromParts(String path, Mail mail, String fileName) throws IOException {
        String fullPath = this.writeMail.writeMailFromParts(path, mail, fileName, this.waitTime);
        LOGGER.debug("Part mail is saved as: {}/{}.eml", (Object)path, (Object)fileName);
        return fullPath;
    }

    private String saveMailFromFullMail(String path, Mail mail, String fileName) throws IOException {
        String fullPath = this.writeMail.writeFullMail(path, mail, fileName, this.waitTime);
        LOGGER.debug("Raw mail is saved as: {}/{}.eml", (Object)path, (Object)fileName);
        return fullPath;
    }
}

