/*
 * Decompiled with CFR 0.152.
 */
package de.lwsystems.mailarchive.bennoimport.core.services.msjournal;

import de.lwsystems.mailarchive.bennoimport.core.exceptions.JournalingMailParsingError;
import de.lwsystems.mailarchive.bennoimport.core.models.Mail;
import de.lwsystems.mailarchive.bennoimport.core.services.ICalculateChecksum;
import de.lwsystems.mailarchive.bennoimport.core.services.IMailValidation;
import de.lwsystems.mailarchive.bennoimport.core.services.ITempFileHandling;
import de.lwsystems.mailarchive.bennoimport.core.services.msjournal.IJournalMailConverter;
import de.lwsystems.mailarchive.bennoimport.core.services.msjournal.IJournalMailHandlingService;
import de.lwsystems.mailarchive.bennoimport.core.utils.StreamUtils;
import jakarta.mail.MessagingException;
import jakarta.mail.Session;
import jakarta.mail.internet.MimeMessage;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Optional;
import java.util.Properties;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class MicrosoftJournalMailHandlingService
implements IJournalMailHandlingService {
    private static final Logger LOGGER = LogManager.getLogger(MicrosoftJournalMailHandlingService.class);
    private IJournalMailConverter microsoftJournalMailHandler;
    private final ITempFileHandling tempFileHandling;
    private final IMailValidation mailValidation;
    private final ICalculateChecksum calculateChecksum;

    public MicrosoftJournalMailHandlingService(IJournalMailConverter microsoftJournalMailHandler, ITempFileHandling tempFileHandling, IMailValidation mailValidation, ICalculateChecksum calculateChecksum) {
        this.microsoftJournalMailHandler = microsoftJournalMailHandler;
        this.tempFileHandling = tempFileHandling;
        this.mailValidation = mailValidation;
        this.calculateChecksum = calculateChecksum;
    }

    @Override
    public InputStream getMailFromJournalMail(InputStream journalMailStream) throws IOException {
        byte[] mailBytes = StreamUtils.toByteArray(journalMailStream);
        try {
            MimeMessage journalMessage = new MimeMessage(Session.getDefaultInstance((Properties)new Properties()), (InputStream)new ByteArrayInputStream(mailBytes));
            if (journalMessage.getHeader("X-MS-Journal-Report") != null) {
                Optional<InputStream> mailOutput = this.microsoftJournalMailHandler.convert(mailBytes, journalMessage);
                if (mailOutput.isPresent()) {
                    LOGGER.debug("Successfully parsed journal mail and created Benno journal mail.");
                    return mailOutput.get();
                }
                throw new JournalingMailParsingError("Failed to create Benno journal mail from the provided journal mail.");
            }
            LOGGER.debug("X-MS-Journal-Report header doesn't exist in sent mail. In this case, the sent mail will be forwarded.");
        }
        catch (JournalingMailParsingError ex) {
            LOGGER.error(ex.getMessage());
            this.handleException(new ByteArrayInputStream(mailBytes));
            throw new JournalingMailParsingError(ex.getMessage());
        }
        catch (MessagingException ex) {
            this.handleException(new ByteArrayInputStream(mailBytes));
            LOGGER.error("Failed to parse journal mail", (Throwable)ex);
            throw new JournalingMailParsingError(ex.getMessage());
        }
        return new ByteArrayInputStream(mailBytes);
    }

    private void handleException(InputStream journalMessage) {
        try {
            Optional<Mail> originalMail = this.mailValidation.createMail(journalMessage);
            if (originalMail.isPresent()) {
                this.tempFileHandling.createTempFileForStorageUrls(originalMail.get(), this.calculateChecksum.calculateMailChecksum(originalMail.get()));
            } else {
                LOGGER.error("Failed to create temp file for journal mail");
            }
        }
        catch (IOException ex) {
            LOGGER.error("Failed to create temp file for journal mail", (Throwable)ex);
        }
    }
}

