/*
 * Decompiled with CFR 0.152.
 */
package de.lwsystems.mailarchive.bennoimport.core.utils;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import jakarta.validation.ConstraintViolation;
import jakarta.validation.MessageInterpolator;
import jakarta.validation.Validation;
import jakarta.validation.Validator;
import jakarta.validation.ValidatorFactory;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.hibernate.validator.HibernateValidator;
import org.hibernate.validator.HibernateValidatorConfiguration;
import org.hibernate.validator.messageinterpolation.ParameterMessageInterpolator;

public final class ParseYamlUtils {
    private static final Logger LOGGER = LogManager.getLogger(ParseYamlUtils.class);

    private ParseYamlUtils() {
    }

    public static <T> T parseYamlContent(String yamlContent, Class<T> parseClass) throws JsonProcessingException {
        ObjectMapper mapper = new ObjectMapper((JsonFactory)new YAMLFactory());
        mapper.enable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES);
        mapper.enable(DeserializationFeature.FAIL_ON_NULL_FOR_PRIMITIVES);
        mapper.enable(DeserializationFeature.FAIL_ON_MISSING_CREATOR_PROPERTIES);
        Object parsedObject = mapper.readValue(yamlContent, parseClass);
        try (ValidatorFactory factory = ((HibernateValidatorConfiguration)((HibernateValidatorConfiguration)Validation.byProvider(HibernateValidator.class).configure()).messageInterpolator((MessageInterpolator)new ParameterMessageInterpolator())).buildValidatorFactory();){
            Validator validator = factory.getValidator();
            Set violations = validator.validate(parsedObject, new Class[0]);
            if (!violations.isEmpty()) {
                StringBuilder sb = new StringBuilder();
                for (ConstraintViolation violation : violations) {
                    sb.append(violation.getPropertyPath()).append(": ").append(violation.getMessage()).append("\n");
                }
                LOGGER.error("YAML validation failed: {}", (Object)sb);
                throw new JsonParseException("YAML validation failed:\n" + String.valueOf(sb));
            }
            Object object = parsedObject;
            return (T)object;
        }
    }
}

