/*
 * Decompiled with CFR 0.152.
 */
package de.lwsystems.mailarchive.bennoimport.core.services;

import de.lwsystems.mailarchive.bennoimport.core.services.IDirectoryHandler;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DirectoryHandler
implements IDirectoryHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(DirectoryHandler.class);

    @Override
    public void createDirectory(Path dirPath) throws IOException {
        if (!Files.exists(dirPath, new LinkOption[0])) {
            LOGGER.debug("Creating temp-directory: {}", (Object)dirPath);
            Files.createDirectory(dirPath, new FileAttribute[0]);
        } else {
            LOGGER.debug("Directory already exists: {}", (Object)dirPath);
        }
    }

    @Override
    public boolean deleteDirectory(Path dirPath) throws IOException {
        if (Files.isDirectory(dirPath, new LinkOption[0])) {
            try (Stream<Path> filesInDir = Files.list(dirPath);){
                if (filesInDir.findAny().isEmpty()) {
                    LOGGER.debug("Deleting empty directory: {}", (Object)dirPath);
                    Files.delete(dirPath);
                    boolean bl = true;
                    return bl;
                }
                LOGGER.debug("Directory is not empty: {}", (Object)dirPath);
            }
        } else {
            LOGGER.debug("Directory does not exist: {}", (Object)dirPath);
        }
        return false;
    }
}

