/*
 * Decompiled with CFR 0.152.
 */
package de.lwsystems.mailarchive.bennoimport.core.services;

import de.lwsystems.mailarchive.bennoimport.core.services.IFileHandler;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.stream.Stream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class FileHandler
implements IFileHandler {
    private static final Logger LOGGER = LogManager.getLogger(FileHandler.class);

    @Override
    public void createFile(Path filePath, String fileName, String content) throws IOException {
        Path storageUrlFile = filePath.resolve(fileName);
        if (Files.exists(storageUrlFile, new LinkOption[0])) {
            LOGGER.debug("File already exists: {}", (Object)storageUrlFile);
        } else {
            Files.writeString(storageUrlFile, (CharSequence)content, new OpenOption[0]);
        }
    }

    @Override
    public void removeFile(Path filePath) throws IOException {
        Files.deleteIfExists(filePath);
        LOGGER.debug("File has been deleted: {}", (Object)filePath);
    }

    @Override
    public void removeFileIfLast(Path filePath, String fileName) throws IOException {
        Path storageUrlFile = filePath.resolve(fileName);
        if (Files.exists(storageUrlFile, new LinkOption[0])) {
            try (Stream<Path> stream = Files.list(filePath);){
                long fileCount = stream.count();
                if (fileCount > 1L) {
                    LOGGER.debug("Directory has more than one entry, not removing file: {}", (Object)storageUrlFile);
                } else {
                    this.removeFile(storageUrlFile);
                }
            }
        }
    }
}

