/*
 * Decompiled with CFR 0.152.
 */
package de.lwsystems.mailarchive.bennoimport.core.services;

import de.lwsystems.mailarchive.bennoimport.core.models.MailHeadersResult;
import de.lwsystems.mailarchive.bennoimport.core.services.IStreamReader;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class MailStreamReader
implements IStreamReader {
    private static final Logger LOGGER = LogManager.getLogger(MailStreamReader.class);
    private final List<String> secretHeaders;

    public MailStreamReader(List<String> secretHeaders) {
        this.secretHeaders = secretHeaders;
    }

    @Override
    public MailHeadersResult readMailHeaders(InputStream mailInputStream) throws IOException {
        LOGGER.debug("Reading mail headers");
        MailHeadersResult mailHeadersResult = new MailHeadersResult();
        boolean isHeader = true;
        boolean receivedNewline = false;
        ByteArrayOutputStream actualLine = new ByteArrayOutputStream(1024);
        int actualMailByte = mailInputStream.read();
        if (actualMailByte == -1) {
            LOGGER.debug("Input stream is empty");
            isHeader = false;
        }
        while (isHeader) {
            if (actualMailByte == -1) {
                isHeader = false;
                continue;
            }
            String bennoGwHeader = "X-BENNO-GW";
            if (receivedNewline) {
                receivedNewline = false;
                if (actualMailByte == 10 || actualMailByte == 13) {
                    isHeader = false;
                    actualMailByte = this.consumeLineBreak(mailInputStream, actualLine, actualMailByte);
                    this.processAndRemoveHeaderLine(actualLine, mailHeadersResult, this.secretHeaders);
                    this.addHeaderLinesToList(actualLine, bennoGwHeader, mailHeadersResult);
                    actualLine.reset();
                    continue;
                }
                actualLine.write(actualMailByte);
                actualMailByte = mailInputStream.read();
                continue;
            }
            if (actualMailByte == 10 || actualMailByte == 13) {
                receivedNewline = true;
                actualMailByte = this.consumeLineBreak(mailInputStream, actualLine, actualMailByte);
                this.processAndRemoveHeaderLine(actualLine, mailHeadersResult, this.secretHeaders);
                this.addHeaderLinesToList(actualLine, bennoGwHeader, mailHeadersResult);
                actualLine.reset();
                continue;
            }
            actualLine.write(actualMailByte);
            actualMailByte = mailInputStream.read();
        }
        LOGGER.debug("Finished reading mail headers");
        mailHeadersResult.setCurrentByteOfMail(actualMailByte);
        return mailHeadersResult;
    }

    @Override
    public ByteArrayOutputStream readMailBody(InputStream mailInputStream, int actualMailByte) throws IOException {
        LOGGER.debug("Reading mail body");
        try (ByteArrayOutputStream outputStream = new ByteArrayOutputStream();){
            if (actualMailByte != -1) {
                outputStream.write(actualMailByte);
                outputStream.write(IOUtils.toByteArray((InputStream)mailInputStream));
            }
            LOGGER.debug("Finished reading mail body");
            ByteArrayOutputStream byteArrayOutputStream = outputStream;
            return byteArrayOutputStream;
        }
    }

    private void processAndRemoveHeaderLine(ByteArrayOutputStream actualLine, MailHeadersResult mailHeadersResult, List<String> secretFilterHeaders) {
        List<String> headersToRemove = this.getHeaderFromLine(actualLine.toString(), secretFilterHeaders);
        if (headersToRemove.isEmpty()) {
            mailHeadersResult.addDataToMailOutputStream(actualLine.toByteArray());
        } else {
            String[] actualHeader = actualLine.toString().split(":", 2);
            LOGGER.debug("Removed secret header: {}", (Object)actualHeader[0]);
            mailHeadersResult.addDataToSecretHeaderStream(actualLine.toByteArray());
        }
    }

    private void addHeaderLinesToList(ByteArrayOutputStream actualLine, String header, MailHeadersResult mailHeadersResult) {
        List<String> headerResponse = this.getHeaderFromLine(actualLine.toString(), List.of(header));
        if (!headerResponse.isEmpty()) {
            mailHeadersResult.addDataToBennoGwHeaderList(actualLine.toString().split(":", 2)[1].trim());
        }
    }

    private int consumeLineBreak(InputStream mailInputStream, ByteArrayOutputStream actualLine, int actualMailByte) throws IOException {
        actualLine.write(actualMailByte);
        int previousTempByte = actualMailByte;
        actualMailByte = mailInputStream.read();
        if (previousTempByte == 10 && actualMailByte == 13 || previousTempByte == 13 && actualMailByte == 10) {
            actualLine.write(actualMailByte);
            return mailInputStream.read();
        }
        return actualMailByte;
    }

    private List<String> getHeaderFromLine(String headerLine, List<String> filterHeaders) {
        String[] header = headerLine.split(":", 2);
        if (header.length >= 2) {
            return filterHeaders.stream().filter(x -> x.equalsIgnoreCase(header[0])).toList();
        }
        return new ArrayList<String>();
    }
}

