/*
 * Decompiled with CFR 0.152.
 */
package de.lwsystems.mailarchive.bennoimport.core.services;

import de.lwsystems.mailarchive.bennoimport.core.auth.RequestService;
import de.lwsystems.mailarchive.bennoimport.core.auth.RestAuthResponse;
import de.lwsystems.mailarchive.bennoimport.core.services.IUploadMail;
import de.lwsystems.mailarchive.bennoimport.core.utils.BennoImportUtils;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.regex.Matcher;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class RestUploadMail
implements IUploadMail {
    private static final Logger LOGGER = LogManager.getLogger(RestUploadMail.class);
    private final RequestService requestService;

    public RestUploadMail(RequestService requestService) {
        this.requestService = requestService;
    }

    @Override
    public void uploadMail(InputStream mailInputStream, String targetUrl, Map<String, String> mailHeader, String mailChecksum) throws IOException {
        LOGGER.debug("Uploading mail to {}", (Object)targetUrl);
        RestAuthResponse contentResponse = this.requestService.putRequest(mailHeader, targetUrl, mailInputStream.readAllBytes());
        this.validateChecksum(targetUrl, mailChecksum, contentResponse.getContentResponse().getContentAsString());
    }

    private void validateChecksum(String targetUrl, String expectedChecksum, String contentResponse) {
        Matcher responseChecksum = BennoImportUtils.getChecksumFromResponse(contentResponse);
        if (responseChecksum.find()) {
            String actualChecksum = responseChecksum.group();
            if (!actualChecksum.equalsIgnoreCase(expectedChecksum)) {
                LOGGER.warn("Checksum mismatch for {}: remote={}, local={}", (Object)targetUrl, (Object)actualChecksum, (Object)expectedChecksum);
            } else {
                LOGGER.debug("Checksum validation successful for {}", (Object)targetUrl);
            }
        } else {
            LOGGER.warn("No valid checksum response from {}", (Object)targetUrl);
        }
    }
}

