/*
 * Decompiled with CFR 0.152.
 */
package de.lwsystems.mailarchive.bennoimport.core.services;

import de.lwsystems.mailarchive.bennoimport.core.models.Mail;
import de.lwsystems.mailarchive.bennoimport.core.services.IDirectoryHandler;
import de.lwsystems.mailarchive.bennoimport.core.services.IFileHandler;
import de.lwsystems.mailarchive.bennoimport.core.services.IProcessFile;
import de.lwsystems.mailarchive.bennoimport.core.services.ITempFileHandling;
import de.lwsystems.mailarchive.bennoimport.core.utils.BennoImportUtils;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class TempFileHandlingService
implements ITempFileHandling {
    private static final Logger LOGGER = LogManager.getLogger(TempFileHandlingService.class);
    private final String storageFileName = ".storageurl";
    private final IFileHandler fileHandler;
    private final String tempFolder;
    private final IProcessFile processFile;
    private final IDirectoryHandler directoryHandler;

    public TempFileHandlingService(IFileHandler fileHandler, String tempFolder, IProcessFile processFile, IDirectoryHandler directoryHandler) {
        this.fileHandler = fileHandler;
        this.tempFolder = tempFolder;
        this.processFile = processFile;
        this.directoryHandler = directoryHandler;
    }

    @Override
    public Path createTempFileForStorageUrlsWithGwHeaderAndUrl(Mail mail, String mailChecksum, String[] bennoGwHeaders, String targetUrl) throws IOException {
        Path tempEndpointFolder = this.createMD5TempUrlDirectory(targetUrl);
        this.fileHandler.createFile(tempEndpointFolder, ".storageurl", targetUrl);
        String tempFilePath = this.processFile.processFile(mail, tempEndpointFolder.toAbsolutePath().toString(), bennoGwHeaders, mailChecksum);
        LOGGER.debug("Created temporary file: {}", (Object)tempFilePath);
        return new File(tempFilePath).toPath();
    }

    @Override
    public Path createTempFileForLocalFileWithDirPath(Mail mail, String mailChecksum, String dirPathString) throws IOException {
        Path tempEndpointFolder = this.createTempFileDirectory(dirPathString);
        String tempFilePath = this.processFile.processFile(mail, tempEndpointFolder.toAbsolutePath().toString(), mailChecksum);
        LOGGER.debug("Created temporary file: {}", (Object)tempFilePath);
        return new File(tempFilePath).toPath();
    }

    private Path createMD5TempUrlDirectory(String url) throws IOException {
        String md5UrlString = BennoImportUtils.createMd5String(url);
        Path tempEndpointFolder = Path.of(this.tempFolder, md5UrlString);
        this.directoryHandler.createDirectory(tempEndpointFolder);
        return tempEndpointFolder;
    }

    private Path createTempFileDirectory(String path) throws IOException {
        Path tempEndpointFolder = Path.of(this.tempFolder, path);
        this.directoryHandler.createDirectory(tempEndpointFolder);
        return tempEndpointFolder;
    }

    @Override
    public Path createTempFileForStorageUrls(Mail mail, String mailChecksum) throws IOException {
        String tempFilePath = this.processFile.processFile(mail, this.tempFolder, mailChecksum);
        LOGGER.debug("Created temporary file: {}", (Object)tempFilePath);
        return new File(tempFilePath).toPath();
    }

    @Override
    public Path createTempFileForSMTP(Mail mail, String mailChecksum, String[] bennoGwHeaders) throws IOException {
        String tempFilePath = this.processFile.processFile(mail, this.tempFolder, bennoGwHeaders, mailChecksum);
        LOGGER.debug("Created temporary file: {}", (Object)tempFilePath);
        return new File(tempFilePath).toPath();
    }

    @Override
    public void handleTempFile(Path tempFilePath, boolean mailProcessed) {
        try {
            if (mailProcessed) {
                LOGGER.debug("The file has been successfully processed. Deleting temporary file: {}", (Object)tempFilePath.getFileName());
                this.fileHandler.removeFile(tempFilePath.toAbsolutePath());
            } else if (tempFilePath != null) {
                LOGGER.debug("The file could not be processed and therefore remains in the temporary folder. File is: {}", (Object)tempFilePath.getFileName());
            } else {
                LOGGER.debug("The file could not be processed and therefore remains in the temporary folder.");
            }
        }
        catch (IOException ex) {
            LOGGER.warn("Error handling temp file");
            LOGGER.debug((Object)ex);
        }
    }
}

