/*
 * Decompiled with CFR 0.152.
 */
package de.lwsystems.mailarchive.bennoimport.core.services.msjournal;

import de.lwsystems.mailarchive.bennoimport.core.exceptions.JournalingMailParsingError;
import de.lwsystems.mailarchive.bennoimport.core.models.MicrosoftJournalingMail;
import de.lwsystems.mailarchive.bennoimport.core.services.IMailPartHandler;
import de.lwsystems.mailarchive.bennoimport.core.services.msjournal.IEnvelopeGenerator;
import de.lwsystems.mailarchive.bennoimport.core.services.msjournal.IJournalMailConverter;
import de.lwsystems.mailarchive.bennoimport.core.services.msjournal.IMicrosoftJournalMailParser;
import de.lwsystems.mailarchive.bennoimport.core.services.msjournal.IMicrosoftJournalMailParserFactory;
import de.lwsystems.mailarchive.bennoimport.core.services.msjournal.IStreamCombiner;
import de.lwsystems.mailarchive.bennoimport.core.services.msjournal.Rfc822MailPartHandler;
import de.lwsystems.mailarchive.bennoimport.core.services.msjournal.TextPlainMailPartHandler;
import de.lwsystems.mailarchive.bennoimport.core.utils.Base64ContentDecoder;
import de.lwsystems.mailarchive.bennoimport.core.utils.StreamUtils;
import jakarta.mail.BodyPart;
import jakarta.mail.MessagingException;
import jakarta.mail.internet.MimeMessage;
import jakarta.mail.internet.MimeMultipart;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class MicrosoftJournalMail
implements IJournalMailConverter {
    private static final Logger LOGGER = LogManager.getLogger(MicrosoftJournalMail.class);
    private final IEnvelopeGenerator envelopeGenerator;
    private final IStreamCombiner streamCombiner;
    private final IMicrosoftJournalMailParserFactory parserFactory;

    public MicrosoftJournalMail(IMicrosoftJournalMailParserFactory parserFactory, IEnvelopeGenerator envelopeGenerator, IStreamCombiner streamCombiner) {
        this.parserFactory = parserFactory;
        this.envelopeGenerator = envelopeGenerator;
        this.streamCombiner = streamCombiner;
    }

    @Override
    public Optional<InputStream> convert(byte[] mailBytes, MimeMessage mimeMailMessage) throws MessagingException, IOException {
        Object object = mimeMailMessage.getContent();
        if (!(object instanceof MimeMultipart)) {
            LOGGER.warn("Journal message content is not MimeMultipart. Type: {}", (Object)mimeMailMessage.getContent().getClass().getName());
            return Optional.empty();
        }
        MimeMultipart multipart = (MimeMultipart)object;
        IMicrosoftJournalMailParser currentParser = this.parserFactory.createParser();
        AtomicReference originalMessageRef = new AtomicReference();
        IMailPartHandler[] iMailPartHandlerArray = new IMailPartHandler[2];
        iMailPartHandlerArray[0] = new Rfc822MailPartHandler(originalMessageRef::set);
        iMailPartHandlerArray[1] = new TextPlainMailPartHandler(currentParser, new Base64ContentDecoder());
        List<IMailPartHandler> contextualHandlers = Arrays.asList(iMailPartHandlerArray);
        for (int i = 0; i < multipart.getCount(); ++i) {
            BodyPart bodyPart = multipart.getBodyPart(i);
            boolean handled = false;
            for (IMailPartHandler handler : contextualHandlers) {
                if (!handler.canHandle(bodyPart)) continue;
                handler.handle(bodyPart);
                handled = true;
                break;
            }
            if (handled) continue;
            LOGGER.warn("Unexpected body part type: {}", (Object)bodyPart.getContentType());
        }
        MimeMessage originalMessage = (MimeMessage)originalMessageRef.get();
        if (originalMessage == null) {
            LOGGER.error("Original message (rfc822) not found in journal mail.");
            return Optional.empty();
        }
        MicrosoftJournalingMail parsedMailData = currentParser.getParsedMailData();
        if (parsedMailData.getSenders().isEmpty() || parsedMailData.getRecipients().isEmpty()) {
            throw new JournalingMailParsingError("Parsed mail data is incomplete. Senders or recipients are missing.");
        }
        String envelope = this.envelopeGenerator.generateEnvelope(parsedMailData);
        ByteArrayInputStream envelopeStream = new ByteArrayInputStream(envelope.getBytes(StandardCharsets.UTF_8));
        InputStream messageStream = StreamUtils.toInputStream(originalMessage);
        return Optional.of(this.streamCombiner.combine(envelopeStream, messageStream));
    }
}

