/*
 * Decompiled with CFR 0.152.
 */
package de.lwsystems.mailarchive.bennoimport.core.services.msjournal;

import de.lwsystems.mailarchive.bennoimport.core.services.IMailPartHandler;
import jakarta.mail.BodyPart;
import jakarta.mail.MessagingException;
import jakarta.mail.internet.MimeMessage;
import java.io.IOException;
import java.util.function.Consumer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Rfc822MailPartHandler
implements IMailPartHandler {
    private static final Logger LOGGER = LogManager.getLogger(Rfc822MailPartHandler.class);
    private final Consumer<MimeMessage> originalMessageConsumer;

    public Rfc822MailPartHandler(Consumer<MimeMessage> originalMessageConsumer) {
        this.originalMessageConsumer = originalMessageConsumer;
    }

    @Override
    public boolean canHandle(BodyPart bodyPart) throws MessagingException {
        return bodyPart.isMimeType("message/rfc822");
    }

    @Override
    public void handle(BodyPart bodyPart) throws MessagingException, IOException {
        LOGGER.debug("Found original message in journal mail.");
        MimeMessage originalMessage = (MimeMessage)bodyPart.getContent();
        this.originalMessageConsumer.accept(originalMessage);
    }
}

