/*
 * Decompiled with CFR 0.152.
 */
package de.lwsystems.mailarchive.bennoimport.core.utils;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileFilter;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Base64;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.codec.digest.DigestUtils;

public class BennoImportUtils {
    private static final String BASIC_USERNAME = "username";
    private static final String BASIC_PASSWORD = "password";
    private static final String IMPORT_ID = "importid";
    private static final String IMPORT_PW = "importpw";
    static FileFilter emlFileFilter = file -> file.getName().endsWith(".eml");
    private static final Pattern CHECKSUM_RESPONSE = Pattern.compile("\\b[0-9A-F]{30,}\\b$");

    private BennoImportUtils() {
    }

    public static String calculateMailChecksum(ByteArrayOutputStream mailOutputStream) throws IllegalArgumentException {
        Objects.requireNonNull(mailOutputStream, "mailOutputStream must not be null");
        try {
            MessageDigest digest = MessageDigest.getInstance("SHA-256");
            digest.update(mailOutputStream.toByteArray());
            return BennoImportUtils.fromBytesToHex(digest.digest());
        }
        catch (NoSuchAlgorithmException ex) {
            throw new IllegalStateException("SHA-256 hashing algorithm unknown.", ex);
        }
    }

    private static String fromBytesToHex(byte[] bytes) {
        String hexString = bytes == null ? "" : new String(Hex.encodeHex((byte[])bytes, (boolean)false));
        return hexString;
    }

    public static String createMd5String(String text) {
        return DigestUtils.md5Hex((String)text);
    }

    public static Map<String, String> getCredentialsFromBasicAuth(String basicAuth) {
        String headerValue = basicAuth.split(" ")[1];
        String[] credentials = new String(Base64.getDecoder().decode(headerValue)).split(":");
        if (credentials.length == 1) {
            return Map.of(BASIC_USERNAME, credentials[0]);
        }
        return Map.of(BASIC_USERNAME, credentials[0], BASIC_PASSWORD, credentials[1]);
    }

    public static Map<String, String> createStorageUrlUserParamsWithPassword(String basicAuth) {
        Map<String, String> authMap = BennoImportUtils.getCredentialsFromBasicAuth(basicAuth);
        return Map.of(IMPORT_ID, authMap.get(BASIC_USERNAME), IMPORT_PW, authMap.get(BASIC_PASSWORD));
    }

    public static Map<String, String> createStorageUrlUserParamsWithoutPassword(String username) {
        return Map.of(IMPORT_ID, username);
    }

    public static String setFilename(String checksum, String containerName) {
        int FILE_LENGTH = 250;
        Object fileName = !containerName.isEmpty() ? checksum + ":" + containerName : checksum;
        if (((String)fileName).length() > 250) {
            fileName = ((String)fileName).substring(0, 250);
        }
        return fileName;
    }

    public static int determineWaitTimeInMs(File localPath, int waitTimeInMs) {
        try {
            int fileCount = Objects.requireNonNull(localPath.listFiles(emlFileFilter)).length;
            return fileCount > 0 ? fileCount * waitTimeInMs : 0;
        }
        catch (NullPointerException ex) {
            return 0;
        }
    }

    public static Matcher getChecksumFromResponse(String response) {
        return CHECKSUM_RESPONSE.matcher(response);
    }
}

