/*
 * Decompiled with CFR 0.152.
 */
package de.lwsystems.mailarchive.bennoimport.core.utils;

import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;

public class FileCheckerUtils {
    private FileCheckerUtils() {
    }

    public static boolean existsFilePrefixOnSystem(String directoryPath, String filePrefix) throws IOException {
        Path dir = Paths.get(directoryPath, new String[0]);
        ArrayList<String> matchingFiles = new ArrayList<String>();
        if (!Files.isDirectory(dir, new LinkOption[0])) {
            throw new IllegalArgumentException("The path is not a directory: " + directoryPath);
        }
        String pattern = filePrefix + ".*";
        try (DirectoryStream<Path> stream = Files.newDirectoryStream(dir, pattern);){
            for (Path entry : stream) {
                matchingFiles.add(entry.getFileName().toString());
            }
        }
        return !matchingFiles.isEmpty();
    }
}

