/*
 * Decompiled with CFR 0.152.
 */
package de.lwsystems.mailarchive.bennoimport.core.utils;

import io.jsonwebtoken.Claims;
import io.jsonwebtoken.Jwts;
import io.jsonwebtoken.security.Keys;
import java.nio.charset.StandardCharsets;
import java.security.Key;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.Date;
import javax.crypto.SecretKey;

public final class JwtUtil {
    private JwtUtil() {
    }

    public static String generateJwtToken(String subject, String secretKey, long expirationMinutes) {
        SecretKey key = JwtUtil.createSecretKey(secretKey);
        return Jwts.builder().subject(subject).issuedAt(Date.from(Instant.now())).expiration(Date.from(Instant.now().plus(expirationMinutes, ChronoUnit.MINUTES))).signWith((Key)key).compact();
    }

    public static boolean validateJwtToken(String jwtToken, String secretKey) {
        try {
            Jwts.parser().verifyWith(JwtUtil.createSecretKey(secretKey)).build().parseSignedClaims((CharSequence)jwtToken);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static String getSubjectFromToken(String jwtToken, String secretKey) {
        return ((Claims)Jwts.parser().verifyWith(JwtUtil.createSecretKey(secretKey)).build().parseSignedClaims((CharSequence)jwtToken).getPayload()).getSubject();
    }

    public static SecretKey createSecretKey(String secret) {
        return Keys.hmacShaKeyFor((byte[])secret.getBytes(StandardCharsets.UTF_8));
    }
}

