/*
 * Decompiled with CFR 0.152.
 */
package de.lwsystems.mailarchive.bennoimport.core.utils;

import jakarta.mail.MessagingException;
import jakarta.mail.internet.MimeMessage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.Path;

public class StreamUtils {
    private StreamUtils() {
    }

    public static ByteArrayOutputStream convertToByteArrayOutputStream(InputStream inputStream) throws IOException {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        inputStream.transferTo(outputStream);
        return outputStream;
    }

    public static ByteArrayOutputStream convertPathToByteArrayOutputStream(Path filePath) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        Files.copy(filePath, byteArrayOutputStream);
        return byteArrayOutputStream;
    }

    public static InputStream toInputStream(MimeMessage message) throws MessagingException, IOException {
        ByteArrayOutputStream messageOut = new ByteArrayOutputStream();
        message.writeTo((OutputStream)messageOut);
        return new ByteArrayInputStream(messageOut.toByteArray());
    }

    public static byte[] toByteArray(InputStream stream) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        stream.transferTo(baos);
        return baos.toByteArray();
    }
}

