/*
 * Decompiled with CFR 0.152.
 */
package de.lwsystems.mailarchive.bennoimport.core.utils;

import java.util.List;

public class UrlStringUtils {
    private UrlStringUtils() {
    }

    public static boolean isExternalUrl(String url, List<String> hostnames) {
        return url.toLowerCase().matches("^https?://.*") && !UrlStringUtils.isInternalUrl(url, hostnames);
    }

    public static boolean isInternalUrl(String url, List<String> hostnames) {
        return hostnames.stream().anyMatch(hostname -> url.toLowerCase().contains(hostname.toLowerCase()));
    }

    public static boolean isFileUrl(String url) {
        return url.matches("^file://.*");
    }

    public static String getFileUrlPath(String url) {
        return url.replace("file://", "");
    }
}

