/*
 * Decompiled with CFR 0.152.
 */
package org.simplejavamail.converter.internal.mimemessage;

import jakarta.activation.DataSource;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MimeDataSource
implements Comparable<MimeDataSource> {
    private final String name;
    private final DataSource dataSource;
    @Nullable
    private final String contentDescription;
    @Nullable
    private final String contentTransferEncoding;

    @Override
    public int compareTo(@NotNull MimeDataSource o) {
        int keyComparison = this.getName().compareTo(o.getName());
        if (keyComparison != 0) {
            return keyComparison;
        }
        return Integer.compare(this.getDataSource().hashCode(), o.getDataSource().hashCode());
    }

    public boolean equals(Object o) {
        return this == o || o instanceof MimeDataSource && this.compareTo((MimeDataSource)o) == 0;
    }

    public int hashCode() {
        return Objects.hash(this.name, this.dataSource);
    }

    MimeDataSource(String name, DataSource dataSource, @Nullable String contentDescription, @Nullable String contentTransferEncoding) {
        this.name = name;
        this.dataSource = dataSource;
        this.contentDescription = contentDescription;
        this.contentTransferEncoding = contentTransferEncoding;
    }

    public static MimeDataSourceBuilder builder() {
        return new MimeDataSourceBuilder();
    }

    public String getName() {
        return this.name;
    }

    public DataSource getDataSource() {
        return this.dataSource;
    }

    @Nullable
    public String getContentDescription() {
        return this.contentDescription;
    }

    @Nullable
    public String getContentTransferEncoding() {
        return this.contentTransferEncoding;
    }

    public static class MimeDataSourceBuilder {
        private String name;
        private DataSource dataSource;
        private String contentDescription;
        private String contentTransferEncoding;

        MimeDataSourceBuilder() {
        }

        public MimeDataSourceBuilder name(String name) {
            this.name = name;
            return this;
        }

        public MimeDataSourceBuilder dataSource(DataSource dataSource) {
            this.dataSource = dataSource;
            return this;
        }

        public MimeDataSourceBuilder contentDescription(@Nullable String contentDescription) {
            this.contentDescription = contentDescription;
            return this;
        }

        public MimeDataSourceBuilder contentTransferEncoding(@Nullable String contentTransferEncoding) {
            this.contentTransferEncoding = contentTransferEncoding;
            return this;
        }

        public MimeDataSource build() {
            return new MimeDataSource(this.name, this.dataSource, this.contentDescription, this.contentTransferEncoding);
        }

        public String toString() {
            return "MimeDataSource.MimeDataSourceBuilder(name=" + this.name + ", dataSource=" + this.dataSource + ", contentDescription=" + this.contentDescription + ", contentTransferEncoding=" + this.contentTransferEncoding + ")";
        }
    }
}

