/*
 * Decompiled with CFR 0.152.
 */
package de.lwsystems.mailarchive.bennoimport.rest.endpoints;

import de.lwsystems.mailarchive.bennoimport.core.models.authorization.AuthorizationResponse;
import de.lwsystems.mailarchive.bennoimport.core.models.authorization.UploadResponse;
import de.lwsystems.mailarchive.bennoimport.core.services.IMailHandling;
import de.lwsystems.mailarchive.bennoimport.core.services.msjournal.IJournalMailHandlingService;
import de.lwsystems.mailarchive.bennoimport.core.storageurl.StorageUrlMailType;
import de.lwsystems.mailarchive.bennoimport.core.utils.Headers;
import de.lwsystems.mailarchive.bennoimport.rest.responses.EndpointResponseUtils;
import de.lwsystems.mailarchive.bennoimport.rest.utils.RequestAttributes;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class InboxServlet
extends HttpServlet {
    private static final Logger LOGGER = LogManager.getLogger(InboxServlet.class);
    private final IMailHandling mailHandlingService;
    private final IJournalMailHandlingService journalMailHandlingService;
    private final List<String> hostnames;

    public InboxServlet(IMailHandling mailHandlingService, IJournalMailHandlingService journalMailHandlingService, List<String> hostnames) {
        this.mailHandlingService = mailHandlingService;
        this.journalMailHandlingService = journalMailHandlingService;
        this.hostnames = hostnames;
    }

    protected void doPut(HttpServletRequest request, HttpServletResponse response) {
        if (request.getContentLength() == 0) {
            try {
                EndpointResponseUtils.sendErrorResponse(response, this.createUploadResponse("Empty content not allowed", 400));
            }
            catch (IOException e) {
                LOGGER.error("Failed to send error response for empty content", (Throwable)e);
            }
        } else {
            try {
                UploadResponse uploadResponse = this.handleMailUpload(request);
                this.sendResponse(response, uploadResponse);
            }
            catch (Exception ex) {
                LOGGER.error("Error when processing mail", (Throwable)ex);
                try {
                    EndpointResponseUtils.sendErrorResponse(response, this.createUploadResponse(ex.getMessage(), 500));
                }
                catch (IOException e) {
                    LOGGER.error("Failed to send error response after processing failure", (Throwable)e);
                }
            }
        }
    }

    private UploadResponse handleMailUpload(HttpServletRequest request) throws IOException {
        AuthorizationResponse authorizationResponse = this.getAttributeFromRequest(request, Headers.AUTHORIZATION.getValue(), AuthorizationResponse.class);
        Map requestHeaders = this.getAttributeFromRequest(request, RequestAttributes.HEADERS.getValue(), Map.class);
        LOGGER.debug("Authorization response from StorageUrl endpoint is: {}", (Object)authorizationResponse);
        InputStream mailInputStream = this.getMailStream(authorizationResponse, request);
        return this.processMail(authorizationResponse, requestHeaders, mailInputStream);
    }

    private InputStream getMailStream(AuthorizationResponse authorizationResponse, HttpServletRequest httpRequest) throws IOException {
        Object mailStream = httpRequest.getInputStream();
        if (StorageUrlMailType.MSJOURNAL.getValue().equals(authorizationResponse.getData().getMailType())) {
            mailStream = this.journalMailHandlingService.getMailFromJournalMail((InputStream)mailStream);
        }
        return mailStream;
    }

    private UploadResponse processMail(AuthorizationResponse authorizationResponse, Map<String, String> headers, InputStream mailStream) {
        try {
            return this.mailHandlingService.processMail(mailStream, authorizationResponse, headers, this.hostnames);
        }
        catch (IOException ex) {
            LOGGER.error("Error when processing mail", (Throwable)ex);
            return this.createUploadResponse(ex.getMessage(), 500);
        }
    }

    private void sendResponse(HttpServletResponse response, UploadResponse uploadResponse) throws IOException {
        if (uploadResponse.getStatus() == 200) {
            LOGGER.debug("Mail processed successfully with checksum: {}", (Object)uploadResponse.getChecksum());
            EndpointResponseUtils.sendSuccessResponse(response, uploadResponse);
        } else {
            LOGGER.debug("Error processing archive mail with checksum: {}", (Object)uploadResponse.getChecksum());
            EndpointResponseUtils.sendErrorResponse(response, uploadResponse);
        }
    }

    private <T> T getAttributeFromRequest(HttpServletRequest request, String attributeName, Class<T> attributeClass) {
        Object attribute = request.getAttribute(attributeName);
        if (attributeClass.isInstance(attribute)) {
            return (T)attribute;
        }
        LOGGER.error("Attribute {} is not of type {}", (Object)attributeName, (Object)attributeClass.getName());
        throw new IllegalStateException("Attribute " + attributeName + " is not of type " + attributeClass.getName());
    }

    private UploadResponse createUploadResponse(String message, int status) {
        return new UploadResponse(message, status);
    }
}

