/*
 * Decompiled with CFR 0.152.
 */
package de.lwsystems.mailarchive.bennoimport.rest.filter;

import de.lwsystems.mailarchive.bennoimport.core.config.yaml.Jwt;
import de.lwsystems.mailarchive.bennoimport.core.exceptions.HttpClientException;
import de.lwsystems.mailarchive.bennoimport.core.utils.BennoHeaderUtils;
import de.lwsystems.mailarchive.bennoimport.core.utils.Headers;
import de.lwsystems.mailarchive.bennoimport.core.utils.JwtUtil;
import de.lwsystems.mailarchive.bennoimport.rest.config.yaml.endpoints.ArchiveEndpoint;
import de.lwsystems.mailarchive.bennoimport.rest.handler.BasicAuthHandler;
import de.lwsystems.mailarchive.bennoimport.rest.handler.BearerTokenHandler;
import de.lwsystems.mailarchive.bennoimport.rest.handler.IAuthorizationHeaderFactory;
import de.lwsystems.mailarchive.bennoimport.rest.handler.IAuthorizationHeaderHandler;
import de.lwsystems.mailarchive.bennoimport.rest.records.BasicAuthRecord;
import de.lwsystems.mailarchive.bennoimport.rest.utils.BasicAuthUtils;
import de.lwsystems.mailarchive.bennoimport.rest.utils.ErrorHandlingUtils;
import jakarta.servlet.Filter;
import jakarta.servlet.FilterChain;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import javax.security.auth.login.LoginException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ArchiveAuthorizationRequestFilter
implements Filter {
    private static final Logger LOGGER = LogManager.getLogger(ArchiveAuthorizationRequestFilter.class);
    public final Jwt jwtConfig;
    private final IAuthorizationHeaderFactory authorizationHeaderFactory;
    private final ArchiveEndpoint archiveEndpointConfig;

    public ArchiveAuthorizationRequestFilter(IAuthorizationHeaderFactory authorizationHeaderFactory, Jwt jwtConfig, ArchiveEndpoint archiveEndpointConfig) {
        this.authorizationHeaderFactory = authorizationHeaderFactory;
        this.jwtConfig = jwtConfig;
        this.archiveEndpointConfig = archiveEndpointConfig;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        HttpServletRequest request = (HttpServletRequest)servletRequest;
        HttpServletResponse response = (HttpServletResponse)servletResponse;
        response.setContentType("application/json; charset=UTF-8");
        LOGGER.debug("Entering ArchiveAuthorizationRequestFilter for request: {}", (Object)request.getRequestURI());
        try {
            this.processAuthorization(request, response, filterChain);
        }
        catch (LoginException ex) {
            ErrorHandlingUtils.handleError(ex.getMessage(), 401, response);
        }
        catch (HttpClientException | IOException | IllegalArgumentException | NullPointerException ex) {
            ErrorHandlingUtils.handleError(ex.getMessage(), 500, response);
        }
        finally {
            LOGGER.debug("Exiting ArchiveAuthorizationRequestFilter for request: {}", (Object)request.getRequestURI());
        }
    }

    private void processAuthorization(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws LoginException, HttpClientException, IOException, ServletException {
        String authorizationData = request.getHeader(Headers.AUTHORIZATION.getValue());
        if (authorizationData == null || authorizationData.isEmpty()) {
            LOGGER.error("No Authorization header was found");
            throw new LoginException("No Authorization header was found");
        }
        this.authenticateRequest(authorizationData);
        LOGGER.debug("Archive authorization was successful");
        filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
    }

    private void authenticateRequest(String authorizationData) throws LoginException, HttpClientException, IllegalArgumentException {
        IAuthorizationHeaderHandler authorizationHeaderHandler = this.authorizationHeaderFactory.createHandler(authorizationData);
        if (authorizationHeaderHandler instanceof BearerTokenHandler) {
            String token = BennoHeaderUtils.getTokenFromBearerAuth((String)authorizationData);
            if (!JwtUtil.validateJwtToken((String)token, (String)this.jwtConfig.getSharedSecret())) {
                LOGGER.error("Bearer token is not valid");
                throw new LoginException("Bearer token is not valid");
            }
        } else if (authorizationHeaderHandler instanceof BasicAuthHandler) {
            BasicAuthRecord basicAuthRecord = BasicAuthUtils.extractCredentials(authorizationData);
            if (!this.archiveEndpointConfig.getBasicAuth().getUsername().equals(basicAuthRecord.username()) || !this.archiveEndpointConfig.getBasicAuth().getPassword().equals(basicAuthRecord.password())) {
                LOGGER.error("Username or Password is not correct");
                throw new LoginException("Username or Password is not correct");
            }
        } else {
            throw new IllegalArgumentException("No valid Authorization header found.");
        }
    }
}

