/*
 * Decompiled with CFR 0.152.
 */
package de.lwsystems.mailarchive.bennoimport.rest.filter;

import com.fasterxml.jackson.core.JsonProcessingException;
import de.lwsystems.mailarchive.bennoimport.core.config.yaml.Jwt;
import de.lwsystems.mailarchive.bennoimport.core.config.yaml.storageurl.StorageUrl;
import de.lwsystems.mailarchive.bennoimport.core.exceptions.HttpClientException;
import de.lwsystems.mailarchive.bennoimport.core.models.authorization.AuthorizationResponse;
import de.lwsystems.mailarchive.bennoimport.core.utils.BennoHeaderUtils;
import de.lwsystems.mailarchive.bennoimport.core.utils.BennoImportUtils;
import de.lwsystems.mailarchive.bennoimport.core.utils.Headers;
import de.lwsystems.mailarchive.bennoimport.core.utils.JwtUtil;
import de.lwsystems.mailarchive.bennoimport.rest.config.yaml.rest.RestServer;
import de.lwsystems.mailarchive.bennoimport.rest.handler.BasicAuthHandler;
import de.lwsystems.mailarchive.bennoimport.rest.handler.BearerTokenHandler;
import de.lwsystems.mailarchive.bennoimport.rest.handler.IAuthorizationHeaderFactory;
import de.lwsystems.mailarchive.bennoimport.rest.handler.IAuthorizationHeaderHandler;
import de.lwsystems.mailarchive.bennoimport.rest.records.AuthenticationResult;
import de.lwsystems.mailarchive.bennoimport.rest.utils.ErrorHandlingUtils;
import de.lwsystems.mailarchive.bennoimport.rest.utils.RequestAttributes;
import jakarta.servlet.Filter;
import jakarta.servlet.FilterChain;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.Map;
import javax.security.auth.login.LoginException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class InboxAuthorizationRequestFilter
implements Filter {
    private static final Logger LOGGER = LogManager.getLogger(InboxAuthorizationRequestFilter.class);
    public final Jwt jwtConfig;
    public final StorageUrl storageUrl;
    private final IAuthorizationHeaderFactory authorizationHeaderFactory;
    private final RestServer restServerConfig;

    public InboxAuthorizationRequestFilter(IAuthorizationHeaderFactory authorizationHeaderFactory, Jwt jwtConfig, StorageUrl storageUrl, RestServer restServerConfig) {
        this.authorizationHeaderFactory = authorizationHeaderFactory;
        this.jwtConfig = jwtConfig;
        this.storageUrl = storageUrl;
        this.restServerConfig = restServerConfig;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        HttpServletRequest request = (HttpServletRequest)servletRequest;
        HttpServletResponse response = (HttpServletResponse)servletResponse;
        response.setContentType("application/json; charset=UTF-8");
        LOGGER.debug("Entering InboxAuthorizationRequestFilter for request: {}", (Object)request.getRequestURI());
        try {
            this.processAuthorization(request, response, filterChain);
        }
        catch (LoginException ex) {
            ErrorHandlingUtils.handleError(ex.getMessage(), 401, response);
        }
        catch (HttpClientException | IOException | IllegalArgumentException | NullPointerException ex) {
            ErrorHandlingUtils.handleError(ex.getMessage(), 500, response);
        }
        finally {
            LOGGER.debug("Exiting InboxAuthorizationRequestFilter for request: {}", (Object)request.getRequestURI());
        }
    }

    private void processAuthorization(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws LoginException, HttpClientException, IOException, ServletException {
        String authorizationData = request.getHeader(Headers.AUTHORIZATION.getValue());
        if (authorizationData == null || authorizationData.isEmpty()) {
            LOGGER.error("No Authorization header was found");
            throw new LoginException("No Authorization header was found");
        }
        Map storageUrlHeader = BennoHeaderUtils.createBearerTokenHeader((String)this.storageUrl.getToken());
        String pathInfo = request.getPathInfo();
        AuthenticationResult authResult = this.authenticateRequest(authorizationData, storageUrlHeader, pathInfo);
        LOGGER.debug("Inbox authorization was successful");
        this.setHostnameAndPort(request);
        this.setRequestAttributes(request, authResult);
        filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
    }

    private AuthenticationResult authenticateRequest(String authorizationData, Map<String, String> storageUrlHeader, String pathInfo) throws HttpClientException, IllegalArgumentException, IOException, LoginException {
        IAuthorizationHeaderHandler authorizationHeaderHandler = this.authorizationHeaderFactory.createHandler(authorizationData);
        if (authorizationHeaderHandler instanceof BasicAuthHandler) {
            Map credentials = BennoImportUtils.getCredentialsFromBasicAuth((String)authorizationData);
            String importId = (String)credentials.get("username");
            return authorizationHeaderHandler.handleAuthorizationHeader(authorizationData, importId, storageUrlHeader, this.storageUrl.getEndpoint());
        }
        if (authorizationHeaderHandler instanceof BearerTokenHandler) {
            String token = BennoHeaderUtils.getTokenFromBearerAuth((String)authorizationData);
            if (!JwtUtil.validateJwtToken((String)token, (String)this.jwtConfig.getSharedSecret())) {
                LOGGER.error("Bearer token is not valid");
                throw new LoginException("Bearer token is not valid");
            }
            String noPassUrl = this.storageUrl.getEndpoint() + "/nopass";
            return authorizationHeaderHandler.handleAuthorizationHeader(authorizationData, pathInfo.substring(1), storageUrlHeader, noPassUrl);
        }
        throw new IllegalArgumentException("No valid Authorization header found.");
    }

    private void setHostnameAndPort(HttpServletRequest request) {
        String baseUri = request.getServerName() + ":" + request.getServerPort();
        LOGGER.debug("Setting baseUri to: {}", (Object)baseUri);
        this.restServerConfig.setBaseUri(baseUri);
    }

    private void setRequestAttributes(HttpServletRequest request, AuthenticationResult authResult) throws JsonProcessingException {
        LOGGER.trace("Setting request attributes for further processing");
        request.setAttribute(RequestAttributes.AUTHORIZATION.getValue(), authResult.response().getParsedContentResponse(AuthorizationResponse.class));
        LOGGER.trace("Authorization response: {}", request.getAttribute(RequestAttributes.AUTHORIZATION.getValue()));
        request.setAttribute(RequestAttributes.HEADERS.getValue(), Map.of(RequestAttributes.AUTHORIZATION.getValue(), request.getHeader(Headers.AUTHORIZATION.getValue())));
        LOGGER.trace("Headers: {}", request.getAttribute(RequestAttributes.HEADERS.getValue()));
        request.setAttribute(RequestAttributes.IMPORTID.getValue(), (Object)authResult.importId());
        LOGGER.trace("ImportID: {}", request.getAttribute(RequestAttributes.IMPORTID.getValue()));
        request.setAttribute(RequestAttributes.BASE_URI.getValue(), (Object)this.restServerConfig.getBaseUri());
        LOGGER.trace("BaseUri: {}", request.getAttribute(RequestAttributes.BASE_URI.getValue()));
    }
}

