/*
 * Decompiled with CFR 0.152.
 */
package de.lwsystems.mailarchive.bennoimport.rest.handler;

import de.lwsystems.mailarchive.bennoimport.core.auth.IRequestService;
import de.lwsystems.mailarchive.bennoimport.rest.handler.BasicAuthHandler;
import de.lwsystems.mailarchive.bennoimport.rest.handler.BearerTokenHandler;
import de.lwsystems.mailarchive.bennoimport.rest.handler.IAuthorizationHeaderFactory;
import de.lwsystems.mailarchive.bennoimport.rest.handler.IAuthorizationHeaderHandler;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class AuthorizationHeaderFactory
implements IAuthorizationHeaderFactory {
    private static final Logger LOGGER = LogManager.getLogger(AuthorizationHeaderFactory.class);
    private final IRequestService requestService;

    public AuthorizationHeaderFactory(IRequestService requestService) {
        this.requestService = requestService;
    }

    @Override
    public IAuthorizationHeaderHandler createHandler(String authorizationHeader) {
        if (authorizationHeader == null || authorizationHeader.isEmpty()) {
            LOGGER.error("Authorization header is empty");
            return null;
        }
        if (authorizationHeader.toLowerCase().contains("bearer")) {
            LOGGER.debug("Bearer token authorization");
            return new BearerTokenHandler(this.requestService);
        }
        if (authorizationHeader.toLowerCase().contains("basic")) {
            LOGGER.debug("Basic auth authorization");
            return new BasicAuthHandler(this.requestService);
        }
        LOGGER.error("Unknown or not supported authorization type: {}", (Object)authorizationHeader);
        throw new IllegalArgumentException("Unknown or not supported authorization type: " + authorizationHeader);
    }
}

