/*
 * Decompiled with CFR 0.152.
 */
package de.lwsystems.mailarchive.bennoimport.rest.models;

import de.lwsystems.mailarchive.bennoimport.rest.models.IEndpointCounter;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class EndpointCounter
implements IEndpointCounter {
    private static final Logger LOGGER = LogManager.getLogger(EndpointCounter.class);
    private final int minBackends;
    private int counter = 0;

    public EndpointCounter(int minBackends) {
        this.minBackends = minBackends;
    }

    public boolean checkBackendsReached() {
        if (this.counter < this.minBackends) {
            LOGGER.warn("The minimum number of backends of {} was not reached. Only {} backends were reached.", (Object)this.minBackends, (Object)this.counter);
        }
        return this.counter >= this.minBackends;
    }

    @Override
    public void incrementEndpointCounter() {
        ++this.counter;
        LOGGER.debug("Incrementing endpoint counter. New value is: {}", (Object)this.counter);
    }

    @Override
    public boolean isBackendCountZero() {
        return this.counter == 0;
    }
}

