/*
 * Decompiled with CFR 0.152.
 */
package de.lwsystems.mailarchive.bennoimport.rest.services;

import de.lwsystems.mailarchive.bennoimport.core.models.Mail;
import de.lwsystems.mailarchive.bennoimport.core.models.authorization.AuthorizationResponse;
import de.lwsystems.mailarchive.bennoimport.core.models.authorization.UploadResponse;
import de.lwsystems.mailarchive.bennoimport.core.services.IMailProcessing;
import de.lwsystems.mailarchive.bennoimport.rest.services.ILocalFileHandling;
import de.lwsystems.mailarchive.bennoimport.rest.services.IStorageUrlHandling;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.List;
import java.util.Map;

public class MailProcessingService
implements IMailProcessing {
    private final IStorageUrlHandling storageUrlHandling;
    private final ILocalFileHandling localFileHandling;

    public MailProcessingService(IStorageUrlHandling storageUrlHandling, ILocalFileHandling localFileHandling) {
        this.storageUrlHandling = storageUrlHandling;
        this.localFileHandling = localFileHandling;
    }

    public UploadResponse processMailUrls(ByteArrayOutputStream mailOutputStream, Mail mail, String mailChecksum, AuthorizationResponse authorizationResponse, Map<String, String> requestHeaders, List<String> hostnames) throws IOException {
        boolean backendsReached = this.storageUrlHandling.processMailUrls(mailOutputStream, mail, mailChecksum, authorizationResponse, requestHeaders, hostnames);
        if (backendsReached) {
            return new UploadResponse(mailChecksum, "Mail import was successful", 200, mailChecksum);
        }
        return new UploadResponse(mailChecksum, "The minimum number of endpoints was not reached", 500, mailChecksum);
    }

    public UploadResponse processLocalFile(ByteArrayOutputStream mailOutputStream, Mail mail, String mailChecksum) throws IOException {
        this.localFileHandling.processLocalFile(mailOutputStream, mail, mailChecksum);
        return new UploadResponse(mailChecksum, "Mail import was successful", 200, mailChecksum);
    }
}

