/*
 * Decompiled with CFR 0.152.
 */
package de.lwsystems.mailarchive.bennoimport.smtp.authentication;

import de.lwsystems.mailarchive.bennoimport.core.config.yaml.Jwt;
import de.lwsystems.mailarchive.bennoimport.core.utils.BennoHeaderUtils;
import de.lwsystems.mailarchive.bennoimport.core.utils.JwtUtil;
import de.lwsystems.mailarchive.bennoimport.smtp.authentication.AuthResult;
import de.lwsystems.mailarchive.bennoimport.smtp.authentication.BaseAuthenticationHandler;
import de.lwsystems.mailarchive.bennoimport.smtp.config.Benno;
import de.lwsystems.mailarchive.bennoimport.smtp.exceptions.BennoImportSmtpException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.Objects;
import org.subethamail.smtp.MessageContext;

public class JwtAuthHandler
extends BaseAuthenticationHandler {
    private final Benno bennoConfig;
    private final Jwt jwtConfig;

    public JwtAuthHandler(Benno bennoConfig, Jwt jwtConfig) {
        this.bennoConfig = bennoConfig;
        this.jwtConfig = jwtConfig;
    }

    @Override
    public AuthResult authenticate(MessageContext messageContext, String recipient) throws BennoImportSmtpException {
        if (this.bennoConfig.getRestEndpoint().getJwt() != null) {
            String token = JwtUtil.generateJwtToken((String)recipient, (String)this.jwtConfig.getSharedSecret(), (long)this.jwtConfig.getExpirationMinutes());
            Map headers = BennoHeaderUtils.createBearerTokenHeader((String)token);
            return new AuthResult(headers, this);
        }
        return this.tryNext(messageContext, recipient);
    }

    @Override
    public StringBuilder modifyUrl(StringBuilder url, String recipient) {
        this.appendRecipientToUrl(recipient, url);
        return url;
    }

    private void appendRecipientToUrl(String recipient, StringBuilder url) {
        Objects.requireNonNull(recipient, "Recipient cannot be null");
        Objects.requireNonNull(url, "URL cannot be null");
        url.append("/").append(URLEncoder.encode(recipient, StandardCharsets.UTF_8));
    }
}

