/*
 * Decompiled with CFR 0.152.
 */
package de.lwsystems.mailarchive.bennoimport.smtp.listeners;

import de.lwsystems.mailarchive.bennoimport.smtp.exceptions.BennoImportSmtpException;
import de.lwsystems.mailarchive.bennoimport.smtp.listeners.IBennoMessageListener;
import java.io.IOException;
import java.io.InputStream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.subethamail.smtp.MessageContext;
import org.subethamail.smtp.MessageHandler;
import org.subethamail.smtp.MessageHandlerFactory;
import org.subethamail.smtp.RejectException;

public class BennoMessageHandlerFactory
implements MessageHandlerFactory {
    private final IBennoMessageListener listener;

    public BennoMessageHandlerFactory(IBennoMessageListener listener) {
        this.listener = listener;
    }

    public MessageHandler create(MessageContext messageContext) {
        return new BennoMessageHandler(messageContext, this.listener);
    }

    static class BennoMessageHandler
    implements MessageHandler {
        private static final Logger LOGGER = LogManager.getLogger(BennoMessageHandler.class);
        private final MessageContext messageContext;
        private final IBennoMessageListener listener;
        private String from;
        private String recipient;

        public BennoMessageHandler(MessageContext messageContext, IBennoMessageListener listener) {
            this.messageContext = messageContext;
            this.listener = listener;
        }

        public void from(String from) throws RejectException {
            if (from == null) {
                throw new RejectException("From cannot be null");
            }
            this.from = from;
        }

        public void recipient(String recipient) throws RejectException {
            if (recipient == null) {
                throw new RejectException("Recipient cannot be null");
            }
            this.recipient = recipient;
        }

        public String data(InputStream inputStream) throws RejectException {
            try {
                this.listener.messageArrived(this.messageContext, this.from, this.recipient, inputStream.readAllBytes());
            }
            catch (BennoImportSmtpException | IOException | RejectException ex) {
                LOGGER.error("Error while processing mail", ex);
                throw new RejectException(451, ex.getMessage());
            }
            return this.listener.getResponseMessage();
        }

        public void done() {
        }
    }
}

