/*
 * Decompiled with CFR 0.152.
 */
package de.lwsystems.mailarchive.bennoimport.smtp.listeners;

import de.lwsystems.mailarchive.bennoimport.core.config.yaml.Jwt;
import de.lwsystems.mailarchive.bennoimport.core.exceptions.HttpClientException;
import de.lwsystems.mailarchive.bennoimport.core.models.Mail;
import de.lwsystems.mailarchive.bennoimport.core.services.ICalculateChecksum;
import de.lwsystems.mailarchive.bennoimport.core.services.IMailCreator;
import de.lwsystems.mailarchive.bennoimport.core.services.ITempFileHandling;
import de.lwsystems.mailarchive.bennoimport.core.services.msjournal.IJournalMailHandlingService;
import de.lwsystems.mailarchive.bennoimport.smtp.authentication.AuthResult;
import de.lwsystems.mailarchive.bennoimport.smtp.authentication.AuthenticationHandler;
import de.lwsystems.mailarchive.bennoimport.smtp.authentication.JwtAuthHandler;
import de.lwsystems.mailarchive.bennoimport.smtp.authentication.MessageContextAuthHandler;
import de.lwsystems.mailarchive.bennoimport.smtp.config.Benno;
import de.lwsystems.mailarchive.bennoimport.smtp.exceptions.BennoImportSmtpException;
import de.lwsystems.mailarchive.bennoimport.smtp.listeners.IBennoMessageListener;
import de.lwsystems.mailarchive.bennoimport.smtp.request.IMailUploader;
import de.lwsystems.mailarchive.bennoimport.smtp.validators.IBasicAuthUsernamePasswordValidator;
import java.io.ByteArrayInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.subethamail.smtp.MessageContext;

public class BennoMessageListener
implements IBennoMessageListener {
    private static final Logger LOGGER = LogManager.getLogger(BennoMessageListener.class);
    private final IMailUploader mailUploader;
    private final Benno bennoConfig;
    private final ICalculateChecksum calculateChecksum;
    private final IMailCreator mailCreator;
    private static String responseMessage = "";
    private final ITempFileHandling tempFileHandling;
    private final IJournalMailHandlingService journalMailHandlingService;
    private final AuthenticationHandler authChain;

    public BennoMessageListener(IBasicAuthUsernamePasswordValidator bennoUsernamePasswordValidator, IMailUploader mailUploader, Benno bennoConfig, Jwt jwtConfig, ITempFileHandling tempFileHandling, ICalculateChecksum calculateChecksum, IMailCreator mailCreator, IJournalMailHandlingService journalMailHandlingService) {
        this.mailUploader = mailUploader;
        this.bennoConfig = bennoConfig;
        this.tempFileHandling = tempFileHandling;
        this.calculateChecksum = calculateChecksum;
        this.mailCreator = mailCreator;
        this.journalMailHandlingService = journalMailHandlingService;
        MessageContextAuthHandler messageContextAuth = new MessageContextAuthHandler(bennoUsernamePasswordValidator);
        JwtAuthHandler jwtAuth = new JwtAuthHandler(bennoConfig, jwtConfig);
        jwtAuth.setNext(messageContextAuth);
        this.authChain = jwtAuth;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void messageArrived(MessageContext messageContext, String sender, String recipient, byte[] mailBytes) {
        LOGGER.debug("Message arrived from sender: {} to recipient: {}", (Object)sender, (Object)recipient);
        Path tempFile = null;
        boolean mailProcessed = true;
        try (ByteArrayInputStream mailStream = new ByteArrayInputStream(mailBytes);){
            StringBuilder url = new StringBuilder(this.bennoConfig.getRestEndpoint().getInboxUrl());
            AuthResult authResult = this.authChain.authenticate(messageContext, recipient);
            Map<String, String> headers = authResult.getHeaders();
            AuthenticationHandler authenticationHandler = authResult.getSuccessfulHandler();
            url = authenticationHandler.modifyUrl(url, recipient);
            InputStream processedMailStream = this.journalMailHandlingService.getMailFromJournalMail((InputStream)mailStream);
            Mail mail = this.mailCreator.convertInputStreamToMail(processedMailStream);
            String checksum = this.calculateChecksum.calculateMailChecksum(mail);
            tempFile = this.tempFileHandling.createTempFileForSMTP(mail, checksum, new String[0]);
            String responseString = this.mailUploader.uploadMail(headers, url.toString(), mailBytes);
            this.setResponseMessage(responseString);
            if (responseString.contains("ERROR")) {
                mailProcessed = false;
                LOGGER.error("Mail from {} to {} upload failed: {}", (Object)sender, (Object)recipient, (Object)responseString);
                throw new BennoImportSmtpException(responseString);
            }
            LOGGER.info("Mail from {} to {} uploaded to inboxUrl: {}", (Object)sender, (Object)recipient, (Object)checksum);
        }
        catch (FileNotFoundException ex) {
            try {
                mailProcessed = false;
                LOGGER.error("Configuration file cannot be found", (Throwable)ex);
                throw new BennoImportSmtpException("Configuration file cannot be found", ex);
                catch (HttpClientException ex2) {
                    mailProcessed = false;
                    LOGGER.warn("Error occurred while sending mail from " + sender + " to " + recipient + " to inboxUrl", (Throwable)ex2);
                    throw new BennoImportSmtpException("Error occurred while sending mail to inboxUrl", ex2);
                }
                catch (IOException ex3) {
                    mailProcessed = false;
                    throw new BennoImportSmtpException("Error occurred while processing mail from " + sender + " to " + recipient, ex3);
                }
            }
            catch (Throwable throwable) {
                this.tempFileHandling.handleTempFile(tempFile, mailProcessed);
                throw throwable;
            }
        }
        this.tempFileHandling.handleTempFile(tempFile, mailProcessed);
    }

    @Override
    public String getResponseMessage() {
        return responseMessage;
    }

    @Override
    public void setResponseMessage(String response) {
        responseMessage = response;
    }
}

