/*
 * Decompiled with CFR 0.152.
 */
package de.lwsystems.mailarchive.bennoimport.smtp.request;

import de.lwsystems.mailarchive.bennoimport.core.auth.IRequestService;
import de.lwsystems.mailarchive.bennoimport.core.auth.RestAuthResponse;
import de.lwsystems.mailarchive.bennoimport.smtp.exceptions.BennoImportSmtpException;
import de.lwsystems.mailarchive.bennoimport.smtp.request.IMailUploader;
import java.io.IOException;
import java.util.Map;
import java.util.Objects;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class MailUploader
implements IMailUploader {
    private static final Logger LOGGER = LogManager.getLogger(MailUploader.class);
    private final IRequestService requestService;

    public MailUploader(IRequestService requestService) {
        this.requestService = requestService;
    }

    @Override
    public String uploadMail(Map<String, String> headers, String url, byte[] mailBytes) throws IOException, BennoImportSmtpException {
        Objects.requireNonNull(url, "URL cannot be null");
        Objects.requireNonNull(mailBytes, "MailImport bytes cannot be null");
        LOGGER.debug("Uploading mail to URL: {}", (Object)url);
        RestAuthResponse response = this.requestService.putRequest(headers, url, mailBytes);
        return response.getContentResponse().getContentAsString();
    }
}

